/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.User;

@Configuration
public class UserCache {
    protected final transient Map<UUID, Set<UUID>> lastMessagePlayers = new HashMap<UUID, Set<UUID>>();
    protected LinkedHashMap<UUID, String> playerChannels = new LinkedHashMap();
    protected LinkedHashMap<UUID, SpyColor> localSpies = new LinkedHashMap();
    protected LinkedHashMap<UUID, SpyColor> socialSpies = new LinkedHashMap();

    @NotNull
    public Optional<String> getPlayerChannel(@NotNull UUID uuid) {
        return Optional.ofNullable(this.playerChannels.get(uuid));
    }

    public Optional<Set<UUID>> getLastMessengers(@NotNull UUID uuid) {
        if (this.lastMessagePlayers.containsKey(uuid)) {
            return Optional.of(this.lastMessagePlayers.get(uuid));
        }
        return Optional.empty();
    }

    @NotNull
    public Map<OnlineUser, SpyColor> getSocialSpies(@NotNull List<OnlineUser> recipients, @NotNull HuskChat plugin) {
        LinkedHashMap<OnlineUser, SpyColor> receivers = new LinkedHashMap<OnlineUser, SpyColor>();
        block0: for (UUID player : this.socialSpies.keySet()) {
            SpyColor color = this.socialSpies.get(player);
            Optional<OnlineUser> spy = plugin.getPlayer(player);
            if (spy.isEmpty()) continue;
            for (OnlineUser messageRecipient : recipients) {
                if (!player.equals(messageRecipient.getUuid())) continue;
                continue block0;
            }
            receivers.put(spy.get(), color);
        }
        return receivers;
    }

    public boolean isSocialSpying(@NotNull OnlineUser player) {
        return this.socialSpies.containsKey(player.getUuid());
    }

    @NotNull
    public Map<OnlineUser, SpyColor> getLocalSpies(@NotNull String server, @NotNull HuskChat plugin) {
        LinkedHashMap<OnlineUser, SpyColor> receivers = new LinkedHashMap<OnlineUser, SpyColor>();
        for (UUID player : this.localSpies.keySet()) {
            SpyColor color = this.localSpies.get(player);
            Optional<OnlineUser> spy = plugin.getPlayer(player);
            if (spy.isEmpty() || spy.get().getServerName().equals(server)) continue;
            receivers.put(spy.get(), color);
        }
        return receivers;
    }

    public boolean isLocalSpying(OnlineUser player) {
        return this.localSpies.containsKey(player.getUuid());
    }

    public static enum SpyColor {
        DARK_RED("&4"),
        RED("&c"),
        GOLD("&6"),
        YELLOW("&e"),
        DARK_GREEN("&2"),
        GREEN("&a"),
        AQUA("&b"),
        DARK_AQUA("&3"),
        DARK_BLUE("&1"),
        BLUE("&9"),
        LIGHT_PURPLE("&d"),
        DARK_PURPLE("&5"),
        WHITE("&f"),
        GRAY("&7"),
        DARK_GRAY("&8"),
        BLACK("&9");

        public static final SpyColor DEFAULT_SPY_COLOR;
        public final String colorCode;

        private SpyColor(String colorCode) {
            this.colorCode = colorCode;
        }

        @NotNull
        public static List<String> getColorStrings() {
            ArrayList<String> colors = new ArrayList<String>();
            for (SpyColor color : SpyColor.values()) {
                colors.add(color.name().toLowerCase());
            }
            return colors;
        }

        public static Optional<SpyColor> getColor(@NotNull String colorInput) {
            for (SpyColor color : SpyColor.values()) {
                if (!color.colorCode.replace("&", "").equals(colorInput.replace("&", "")) && !color.name().equalsIgnoreCase(colorInput.toUpperCase())) continue;
                return Optional.of(color);
            }
            return Optional.empty();
        }

        static {
            DEFAULT_SPY_COLOR = DARK_GRAY;
        }
    }

    public static class Editor
    extends UserCache {
        public void setLastMessenger(@NotNull UUID playerToSet, @NotNull List<OnlineUser> lastMessengers) {
            HashSet<UUID> uuidPlayers = new HashSet<UUID>();
            for (OnlineUser player : lastMessengers) {
                uuidPlayers.add(player.getUuid());
            }
            this.lastMessagePlayers.put(playerToSet, uuidPlayers);
        }

        public void setPlayerChannel(@NotNull UUID uuid, @NotNull String channelId) {
            this.playerChannels.put(uuid, channelId);
        }

        public void switchPlayerChannel(@NotNull OnlineUser user, @NotNull String channelId, @NotNull HuskChat plugin) {
            Optional<Channel> optionalChannel = plugin.getChannels().getChannel(channelId);
            if (optionalChannel.isEmpty()) {
                plugin.getLocales().sendMessage(user, "error_invalid_channel", new String[0]);
                return;
            }
            Channel channel = optionalChannel.get();
            if (!channel.canUserSend(user)) {
                plugin.getLocales().sendMessage(user, "error_no_permission_send", channel.getId());
                return;
            }
            this.setPlayerChannel(user.getUuid(), channel.getId());
            plugin.getLocales().sendMessage(user, "channel_switched", channel.getId());
        }

        public void setSocialSpy(@NotNull User user) {
            this.socialSpies.put(user.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
        }

        public void setSocialSpy(@NotNull User user, @NotNull SpyColor spyColor) {
            this.socialSpies.put(user.getUuid(), spyColor);
        }

        public void removeSocialSpy(@NotNull User user) {
            this.socialSpies.remove(user.getUuid());
        }

        public void setLocalSpy(@NotNull User user) {
            this.localSpies.put(user.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
        }

        public void setLocalSpy(@NotNull User user, @NotNull SpyColor spyColor) {
            this.localSpies.put(user.getUuid(), spyColor);
        }

        public void removeLocalSpy(@NotNull User user) {
            this.localSpies.remove(user.getUuid());
        }
    }
}

