/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.william278.huskchat.BungeeHuskChat;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.LocalSpyCommand;
import net.william278.huskchat.command.MessageCommand;
import net.william278.huskchat.command.OptOutMessageCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.BungeeUser;
import net.william278.huskchat.user.ConsoleUser;

public class BungeeCommand
extends Command
implements TabExecutor {
    private final BungeeHuskChat plugin;
    private final CommandBase command;

    public BungeeCommand(@NotNull CommandBase command, @NotNull BungeeHuskChat plugin) {
        super(command.getName(), command.getPermission(new String[0]), command.getAliases().toArray(new String[0]));
        this.command = command;
        this.plugin = plugin;
        plugin.getProxy().getPluginManager().registerCommand((Plugin)plugin, (Command)this);
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)sender;
            BungeeUser user = BungeeUser.adapt(player, this.plugin);
            if (!user.hasPermission(this.command.getPermission(new String[0]), !this.command.isOperatorOnly())) {
                this.plugin.getLocales().sendMessage(user, "error_no_permission", new String[0]);
                return;
            }
            this.command.onExecute(user, args);
        } else {
            this.command.onExecute(ConsoleUser.wrap(this.plugin), args);
        }
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!(sender instanceof ProxiedPlayer)) {
            return this.command.onTabComplete(this.plugin.getConsoleUser(), args);
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        BungeeUser user = BungeeUser.adapt(player, this.plugin);
        if (!user.hasPermission(this.command.getPermission(new String[0]), !this.command.isOperatorOnly())) {
            return List.of();
        }
        return this.command.onTabComplete(user, args);
    }

    public static enum Type {
        HUSKCHAT(plugin -> Optional.of(new BungeeCommand(new HuskChatCommand((HuskChat)plugin), (BungeeHuskChat)plugin))),
        CHANNEL(plugin -> Optional.of(new BungeeCommand(new ChannelCommand((HuskChat)plugin), (BungeeHuskChat)plugin))),
        MESSAGE(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new BungeeCommand(new MessageCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        REPLY(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new BungeeCommand(new ReplyCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        OPT_OUT_MESSAGE(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new BungeeCommand(new OptOutMessageCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        BROADCAST(plugin -> plugin.getSettings().getBroadcastCommand().isEnabled() ? Optional.of(new BungeeCommand(new BroadcastCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        SOCIAL_SPY(plugin -> plugin.getSettings().getSocialSpy().isEnabled() ? Optional.of(new BungeeCommand(new SocialSpyCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        LOCAL_SPY(plugin -> plugin.getSettings().getLocalSpy().isEnabled() ? Optional.of(new BungeeCommand(new LocalSpyCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty());

        private final Function<BungeeHuskChat, Optional<BungeeCommand>> commandSupplier;

        private Type(Function<BungeeHuskChat, Optional<BungeeCommand>> commandSupplier) {
            this.commandSupplier = commandSupplier;
        }

        private void register(@NotNull BungeeHuskChat plugin) {
            this.commandSupplier.apply(plugin);
        }

        public static void registerAll(@NotNull BungeeHuskChat plugin) {
            Arrays.stream(Type.values()).forEach(type -> type.register(plugin));
        }
    }
}

