/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.user.OnlineUser;
import org.bukkit.entity.Player;

public class BukkitUser
extends OnlineUser {
    private final Player player;

    private BukkitUser(@NotNull Player player, @NotNull HuskChat plugin) {
        super(player.getName(), player.getUniqueId(), plugin);
        this.player = player;
    }

    @NotNull
    public static BukkitUser adapt(@NotNull Player player, @NotNull HuskChat plugin) {
        return new BukkitUser(player, plugin);
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }

    @Override
    @NotNull
    public String getServerName() {
        return "server";
    }

    @Override
    public int getPlayersOnServer() {
        return this.player.getServer().getOnlinePlayers().size();
    }

    @Override
    public boolean hasPermission(@Nullable String node, boolean allowByDefault) {
        if (node != null && this.player.isPermissionSet(node)) {
            return this.player.hasPermission(node);
        }
        return allowByDefault || this.player.isOp();
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }
}

