/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.user.OnlineUser;

public class BungeeUser
extends OnlineUser {
    private final ProxiedPlayer player;

    private BungeeUser(@NotNull ProxiedPlayer player, @NotNull HuskChat plugin) {
        super(player.getName(), player.getUniqueId(), plugin);
        this.player = player;
    }

    @NotNull
    public static BungeeUser adapt(@NotNull ProxiedPlayer player, @NotNull HuskChat plugin) {
        return new BungeeUser(player, plugin);
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.player.getServer().getInfo().getName();
    }

    @Override
    public int getPlayersOnServer() {
        return this.player.getServer().getInfo().getPlayers().size();
    }

    @Override
    public boolean hasPermission(@Nullable String node, boolean allowByDefault) {
        if (node != null && this.player.getPermissions().contains(node)) {
            return this.player.hasPermission(node);
        }
        return allowByDefault;
    }

    @NotNull
    public ProxiedPlayer getPlayer() {
        return this.player;
    }
}

