/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.discord;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.ChatMessage;

public interface DiscordHook {
    public void postMessage(@NotNull ChatMessage var1);

    public static byte[] getDiscordMessageJson(@NotNull HuskChat plugin, @NotNull ChatMessage message) {
        return plugin.getSettings().getDiscord().getFormatStyle().getPostMessageFormat(plugin).replace("{SENDER_UUID}", message.getSender().getUuid().toString()).replace("{SENDER_CHANNEL}", message.getChannel().getId()).replace("{CURRENT_TIMESTAMP}", ZonedDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).replace("{SENDER_USERNAME}", message.getSender().getName()).replace("{CHAT_MESSAGE}", message.getMessage().replace("\\", "\\\\").replace("\"", "\\\"")).getBytes(StandardCharsets.UTF_8);
    }

    public static enum Format {
        EMBEDDED,
        INLINE;


        @NotNull
        private String getPostMessageFormat(@NotNull HuskChat plugin) {
            try {
                return new String(plugin.getResource(String.format("discord/%s_message.json", this.name().toLowerCase(Locale.ENGLISH))).readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load \"" + this.name() + "\" Discord message format", e);
            }
        }
    }
}

