/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.util.Optional;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.libraries.minedown.adventure.MineDownParser;
import net.william278.huskchat.user.OnlineUser;

public class BroadcastMessage {
    private final Settings.BroadcastSettings settings;
    private final OnlineUser sender;
    private final HuskChat plugin;
    private String message;

    public BroadcastMessage(@NotNull OnlineUser sender, @NotNull String message, @NotNull HuskChat plugin) {
        this.sender = sender;
        this.plugin = plugin;
        this.settings = plugin.getSettings().getBroadcastCommand();
        this.message = message;
    }

    public void dispatch() {
        this.plugin.fireBroadcastMessageEvent(this.sender, this.message).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.message = event.getMessage();
            Optional<String> filtered = this.plugin.filter(this.sender, this.message, this.plugin.getBroadcastFilters());
            if (filtered.isEmpty()) {
                return;
            }
            this.message = filtered.get();
            this.plugin.getOnlinePlayers().forEach(this::sendMessage);
            if (this.settings.isLogToConsole()) {
                this.plugin.log(Level.INFO, this.settings.getLogFormat() + this.message, new Throwable[0]);
            }
        });
    }

    public void sendMessage(@NotNull OnlineUser player) {
        TextComponent.Builder componentBuilder = Component.text();
        componentBuilder.append(new MineDown(this.plugin.getSettings().getBroadcastCommand().getFormat()).toComponent());
        componentBuilder.append(new MineDown(this.message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        player.sendMessage((Component)componentBuilder.build());
    }
}

