/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.util.TriState;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.user.OnlineUser;

public class VelocityUser
extends OnlineUser {
    private final Player player;

    private VelocityUser(@NotNull Player player, @NotNull HuskChat plugin) {
        super(player.getUsername(), player.getUniqueId(), plugin);
        this.player = player;
    }

    @NotNull
    public static VelocityUser adapt(@NotNull Player player, @NotNull HuskChat plugin) {
        return new VelocityUser(player, plugin);
    }

    @Override
    public int getPing() {
        return (int)this.player.getPing();
    }

    @Override
    @NotNull
    public String getServerName() {
        Optional connection = this.player.getCurrentServer();
        if (connection.isPresent()) {
            return ((ServerConnection)connection.get()).getServerInfo().getName();
        }
        return "";
    }

    @Override
    public int getPlayersOnServer() {
        return this.player.getCurrentServer().map(conn -> conn.getServer().getPlayersConnected().size()).orElse(0);
    }

    @Override
    public boolean hasPermission(@Nullable String permission, boolean allowByDefault) {
        if (permission == null) {
            return allowByDefault;
        }
        TriState state = this.player.getPermissionValue(permission).toAdventureTriState();
        if (state == TriState.NOT_SET) {
            return allowByDefault;
        }
        return state == TriState.TRUE;
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.player;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }
}

