/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.api.BukkitHuskChatAPI;
import net.william278.huskchat.command.BukkitCommand;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.config.Channels;
import net.william278.huskchat.config.Filters;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.event.BukkitEventProvider;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.MorePaperLib;
import net.william278.huskchat.listener.BukkitListener;
import net.william278.huskchat.placeholders.BukkitPlaceholderAPIReplacer;
import net.william278.huskchat.placeholders.DefaultReplacer;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.user.BukkitUser;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitHuskChat
extends JavaPlugin
implements HuskChat,
BukkitEventProvider {
    private MorePaperLib morePaperLib;
    private BukkitAudiences audiences;
    private final List<ChatFilter> filtersAndReplacers = new ArrayList<ChatFilter>();
    private final List<PlaceholderReplacer> placeholderReplacers = new ArrayList<PlaceholderReplacer>();
    private Settings settings;
    private Locales locales;
    private Channels channels;
    private Filters filterSettings;
    private UserCache.Editor userCache;
    private DiscordHook discordHook;
    private DataGetter dataGetter;

    public void onEnable() {
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.morePaperLib = new MorePaperLib((Plugin)this);
        this.loadConfig();
        this.loadDiscordHook();
        this.dataGetter = this.isPluginPresent("LuckPerms") ? new LuckPermsDataGetter() : new DefaultDataGetter();
        this.placeholderReplacers.add(new DefaultReplacer(this));
        if (this.getSettings().getPlaceholder().isUsePapi() && this.isPluginPresent("PlaceholderAPI")) {
            this.placeholderReplacers.add(new BukkitPlaceholderAPIReplacer());
        }
        this.getServer().getPluginManager().registerEvents((Listener)new BukkitListener(this), (Plugin)this);
        BukkitCommand.Type.registerAll(this);
        this.getChannels().getChannels().forEach(channel -> channel.getShortcutCommands().forEach(command -> new BukkitCommand(new ShortcutCommand((String)command, channel.getId(), (HuskChat)this), this)));
        BukkitHuskChatAPI.register(this);
        this.checkForUpdates();
        this.log(Level.INFO, "Enabled HuskChat version " + this.getVersion(), new Throwable[0]);
    }

    @Override
    public Optional<DiscordHook> getDiscordHook() {
        return Optional.ofNullable(this.discordHook);
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    @Override
    @NotNull
    public String getPluginDescription() {
        return Optional.ofNullable(this.getDescription().getDescription()).orElseThrow(() -> new IllegalStateException("Plugin description not found"));
    }

    @Override
    @NotNull
    public String getPlatform() {
        return this.getServer().getName();
    }

    @Override
    public Optional<OnlineUser> getPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getServer().getPlayer(uuid)).map(player -> BukkitUser.adapt(player, this));
    }

    @Override
    public Optional<OnlineUser> findPlayer(@NotNull String username) {
        return Optional.ofNullable(this.getServer().getPlayer(username)).map(player -> BukkitUser.adapt(player, this));
    }

    @Override
    @NotNull
    public Collection<OnlineUser> getOnlinePlayers() {
        return this.getServer().getOnlinePlayers().stream().map(user -> BukkitUser.adapt(user, this)).toList();
    }

    @Override
    @NotNull
    public Collection<OnlineUser> getOnlinePlayersOnServer(@NotNull OnlineUser player) {
        return this.getOnlinePlayers();
    }

    @Override
    public boolean isPluginPresent(@NotNull String dependency) {
        return this.getServer().getPluginManager().getPlugin(dependency) != null;
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    @NotNull
    public CommandMap getCommandMap() {
        return this.morePaperLib.commandRegistration().getServerCommandMap();
    }

    @Override
    @NotNull
    public Audience getAudience(@NotNull UUID user) {
        return this.audiences.player(user);
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.audiences.console();
    }

    @Override
    @NotNull
    public Path getConfigDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    @NotNull
    public BukkitHuskChat getPlugin() {
        return this;
    }

    public MorePaperLib getMorePaperLib() {
        return this.morePaperLib;
    }

    public BukkitAudiences getAudiences() {
        return this.audiences;
    }

    @Override
    public List<ChatFilter> getFiltersAndReplacers() {
        return this.filtersAndReplacers;
    }

    @Override
    public List<PlaceholderReplacer> getPlaceholderReplacers() {
        return this.placeholderReplacers;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public Channels getChannels() {
        return this.channels;
    }

    @Override
    public Filters getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public UserCache.Editor getUserCache() {
        return this.userCache;
    }

    @Override
    public DataGetter getDataGetter() {
        return this.dataGetter;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Override
    public void setChannels(Channels channels) {
        this.channels = channels;
    }

    @Override
    public void setFilterSettings(Filters filterSettings) {
        this.filterSettings = filterSettings;
    }

    @Override
    public void setUserCache(UserCache.Editor userCache) {
        this.userCache = userCache;
    }

    @Override
    public void setDiscordHook(DiscordHook discordHook) {
        this.discordHook = discordHook;
    }
}

