/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.api;

import java.util.List;
import java.util.Optional;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.BroadcastMessage;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.message.PrivateMessage;
import net.william278.huskchat.user.OnlineUser;

public class HuskChatAPI {
    protected static HuskChatAPI instance;
    protected final HuskChat plugin;

    protected HuskChatAPI(@NotNull HuskChat plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public static HuskChatAPI getInstance() {
        return instance;
    }

    @NotNull
    public Optional<String> getPlayerChannel(@NotNull OnlineUser player) {
        return this.plugin.getUserCache().getPlayerChannel(player.getUuid());
    }

    public void setPlayerChannel(@NotNull OnlineUser player, @NotNull String channel) {
        this.plugin.editUserCache(c -> c.setPlayerChannel(player.getUuid(), channel));
    }

    public void sendChatMessage(@NotNull String targetChannelId, @NotNull OnlineUser sender, @NotNull String message) {
        Channel channel = this.plugin.getChannels().getChannel(targetChannelId).orElseThrow(() -> new IllegalArgumentException("The target channel does not exist"));
        new ChatMessage(channel, sender, message, this.plugin).dispatch();
    }

    public void sendBroadcastMessage(@NotNull OnlineUser sender, @NotNull String message) {
        new BroadcastMessage(sender, message, this.plugin).dispatch();
    }

    public void sendPrivateMessage(@NotNull OnlineUser sender, @NotNull List<String> targetUsernames, @NotNull String message) {
        new PrivateMessage(sender, targetUsernames, message, this.plugin).dispatch();
    }
}

