/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Unmodifiable;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.OnlineUser;

public class ChannelCommand
extends CommandBase {
    public ChannelCommand(@NotNull HuskChat plugin) {
        super(plugin.getChannels().getChannelCommandAliases(), "<channel>", plugin);
    }

    @Override
    public void onExecute(@NotNull OnlineUser player, @NotNull String[] args) {
        if (player instanceof ConsoleUser) {
            this.plugin.getLocales().sendMessage(player, "error_in_game_only", new String[0]);
            return;
        }
        if (args.length == 1) {
            this.plugin.editUserCache(c -> c.switchPlayerChannel(player, args[0], this.plugin));
        } else {
            this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
        }
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull OnlineUser player, @NotNull String[] args) {
        if (args.length <= 1) {
            return this.getUsableChannels(player).stream().filter(val -> val.toLowerCase().startsWith(args.length == 1 ? args[0].toLowerCase() : "")).sorted().toList();
        }
        return List.of();
    }

    @NotNull
    public @Unmodifiable Set<String> getUsableChannels(@NotNull OnlineUser player) {
        return this.plugin.getChannels().getChannels().stream().filter(c -> c.canUserSend(player)).map(Channel::getId).collect(Collectors.toSet());
    }
}

