/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;

public class EmojiReplacer
extends ChatFilter.ReplacerFilter {
    public EmojiReplacer(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @Override
    @NotNull
    public String replace(@NotNull String message) {
        String[] words = message.split(" ");
        StringJoiner replacedMessage = new StringJoiner(" ");
        EmojiReplacerSettings settings = (EmojiReplacerSettings)this.settings;
        for (String word : words) {
            for (String emoteFormat : settings.getEmoji().keySet()) {
                if (!settings.isCaseInsensitive()) {
                    if (!word.equals(emoteFormat)) continue;
                    word = settings.getEmoji().get(emoteFormat);
                    break;
                }
                if (!word.toLowerCase(Locale.ROOT).equals(emoteFormat)) continue;
                word = settings.getEmoji().get(emoteFormat);
                break;
            }
            replacedMessage.add(word);
        }
        return replacedMessage.toString();
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new EmojiReplacerSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser sender, @NotNull String message) {
        return true;
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        throw new UnsupportedOperationException("EmojiReplacer does not support failure messages");
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.emoji_replacer";
    }

    @Configuration
    public static class EmojiReplacerSettings
    extends ChatFilter.FilterSettings {
        private boolean caseInsensitive = false;
        private Map<String, String> emoji = new HashMap<String, String>(Map.of(":)", "\u263a", ":smile:", "\u263a", ":-)", "\u263a", ":(", "\u2639", ":frown:", "\u2639", ":-(", "\u2639", ":fire:", "\ud83d\udd25", ":heart:", "\u2764", "<3", "\u2764", ":star:", "\u2b50"));

        public boolean isCaseInsensitive() {
            return this.caseInsensitive;
        }

        public Map<String, String> getEmoji() {
            return this.emoji;
        }

        private EmojiReplacerSettings() {
        }
    }
}

