/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.libraries.profanitycheckerapi.ProfanityChecker;
import net.william278.huskchat.user.OnlineUser;

public class ProfanityFilterer
extends ChatFilter {
    @NotNull
    private final ProfanityChecker.ProfanityCheckerBuilder builder;

    public ProfanityFilterer(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
        ProfanityFilterSettings profanitySettings = (ProfanityFilterSettings)settings;
        this.builder = ProfanityChecker.builder();
        if (profanitySettings.getLibraryPath() != null && !profanitySettings.getLibraryPath().isBlank()) {
            this.builder.libraryPath(profanitySettings.getLibraryPath());
        }
        if (profanitySettings.getMode() == ProfanityFilterMode.TOLERANCE) {
            this.builder.useThreshold(true);
            this.builder.threshold(profanitySettings.getTolerance());
        }
        this.initialize();
    }

    private void initialize() {
        try (ProfanityChecker ignored = this.builder.build();){
            System.out.println("Initialized the profanity checker and hooked into the jep interpreter");
        }
        catch (IllegalStateException | UnsatisfiedLinkError e) {
            throw new RuntimeException("Failed to initialize ProfanityChecker (" + e.getMessage() + ")Please ensure that the jep library is installed and the library path is correct. Consult the HuskChat docs for more information on this error.", e);
        }
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new ProfanityFilterSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser player, @NotNull String message) {
        ProfanityChecker checker = this.builder.build();
        try {
            boolean bl;
            boolean bl2 = bl = !checker.isProfane(message);
            if (checker != null) {
                checker.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (checker != null) {
                    try {
                        checker.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_profanity";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.profanity";
    }

    @Configuration
    public static class ProfanityFilterSettings
    extends ChatFilter.FilterSettings {
        public String libraryPath = "";
        public ProfanityFilterMode mode = ProfanityFilterMode.AUTOMATIC;
        public double tolerance = 0.78;

        private ProfanityFilterSettings() {
            this.enabled = false;
        }

        protected ProfanityFilterSettings(@NotNull String libraryPath, @NotNull ProfanityFilterMode mode, double tolerance) {
            this.libraryPath = libraryPath;
            this.mode = mode;
            this.tolerance = tolerance;
        }

        public String getLibraryPath() {
            return this.libraryPath;
        }

        public ProfanityFilterMode getMode() {
            return this.mode;
        }

        public double getTolerance() {
            return this.tolerance;
        }
    }

    public static enum ProfanityFilterMode {
        AUTOMATIC,
        TOLERANCE;

    }
}

