/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;

public class RepeatFilter
extends ChatFilter {
    private final HashMap<UUID, LinkedList<String>> userMessageQueues = new HashMap();

    public RepeatFilter(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new RepeatFilterSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser player, @NotNull String message) {
        if (!this.userMessageQueues.containsKey(player.getUuid())) {
            this.userMessageQueues.put(player.getUuid(), new LinkedList());
        }
        if (!this.userMessageQueues.get(player.getUuid()).isEmpty()) {
            for (String previousMessage : this.userMessageQueues.get(player.getUuid())) {
                if (!message.equalsIgnoreCase(previousMessage)) continue;
                return false;
            }
            if (this.userMessageQueues.get(player.getUuid()).size() + 1 > ((RepeatFilterSettings)this.settings).getPreviousMessagesToCheck()) {
                this.userMessageQueues.get(player.getUuid()).removeLast();
            }
        }
        this.userMessageQueues.get(player.getUuid()).addFirst(message);
        return true;
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_repeat";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.spam";
    }

    @Configuration
    public static class RepeatFilterSettings
    extends ChatFilter.FilterSettings {
        public int previousMessagesToCheck = 5;

        public int getPreviousMessagesToCheck() {
            return this.previousMessagesToCheck;
        }

        private RepeatFilterSettings() {
        }
    }
}

