/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi;

import java.util.List;
import jep.Interpreter;
import jep.MainInterpreter;
import jep.SharedInterpreter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.profanitycheckerapi.Normalizer;

public class ProfanityChecker
implements AutoCloseable {
    private Interpreter interpreter;
    @Nullable
    private String libraryPath;
    @NotNull
    private List<Normalizer> normalizers;
    private boolean useThreshold;
    private double threshold;

    private ProfanityChecker(@Nullable Interpreter interpreter, @Nullable String libraryPath, @NotNull List<Normalizer> normalizers, boolean useThreshold, double threshold) {
        this.interpreter = interpreter;
        this.libraryPath = libraryPath;
        this.normalizers = normalizers;
        this.useThreshold = useThreshold;
        this.threshold = threshold;
        this.initialize();
    }

    public void initialize() {
        if (this.libraryPath != null) {
            MainInterpreter.setJepLibraryPath(this.libraryPath);
        }
        if (this.interpreter == null) {
            this.interpreter = new SharedInterpreter();
        }
        this.interpreter.exec("from profanity_check import predict_prob, predict");
    }

    public boolean isProfane(@NotNull String text) {
        String normalized = this.normalizeText(text);
        return this.useThreshold ? this.getProfanityProbability(normalized) >= this.threshold : this.containsProfanity(normalized);
    }

    protected boolean containsProfanity(@NotNull String text) {
        this.interpreter.set("text", text);
        return this.interpreter.getValue("predict([text])[0].item()", Integer.class) == 1;
    }

    protected double getProfanityProbability(@NotNull String text) {
        this.interpreter.set("text", text);
        return this.interpreter.getValue("predict_prob([text])[0].item()", Double.class);
    }

    @NotNull
    private String normalizeText(@NotNull String text) {
        String normalized = text;
        for (Normalizer normalizer : this.normalizers) {
            normalized = normalizer.normalize(normalized);
        }
        return normalized;
    }

    @Override
    public void close() {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
    }

    private static Interpreter $default$interpreter() {
        return null;
    }

    private static String $default$libraryPath() {
        return null;
    }

    private static List<Normalizer> $default$normalizers() {
        return Normalizer.all();
    }

    private static boolean $default$useThreshold() {
        return false;
    }

    private static double $default$threshold() {
        return 0.9;
    }

    public static ProfanityCheckerBuilder builder() {
        return new ProfanityCheckerBuilder();
    }

    private ProfanityChecker() {
        this.interpreter = ProfanityChecker.$default$interpreter();
        this.libraryPath = ProfanityChecker.$default$libraryPath();
        this.normalizers = ProfanityChecker.$default$normalizers();
        this.useThreshold = ProfanityChecker.$default$useThreshold();
        this.threshold = ProfanityChecker.$default$threshold();
    }

    public static class ProfanityCheckerBuilder {
        private boolean interpreter$set;
        private Interpreter interpreter$value;
        private boolean libraryPath$set;
        private String libraryPath$value;
        private boolean normalizers$set;
        private List<Normalizer> normalizers$value;
        private boolean useThreshold$set;
        private boolean useThreshold$value;
        private boolean threshold$set;
        private double threshold$value;

        ProfanityCheckerBuilder() {
        }

        public ProfanityCheckerBuilder interpreter(Interpreter interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return this;
        }

        public ProfanityCheckerBuilder libraryPath(@Nullable String libraryPath) {
            this.libraryPath$value = libraryPath;
            this.libraryPath$set = true;
            return this;
        }

        public ProfanityCheckerBuilder normalizers(@NotNull List<Normalizer> normalizers) {
            if (normalizers == null) {
                throw new NullPointerException("normalizers is marked non-null but is null");
            }
            this.normalizers$value = normalizers;
            this.normalizers$set = true;
            return this;
        }

        public ProfanityCheckerBuilder useThreshold(boolean useThreshold) {
            this.useThreshold$value = useThreshold;
            this.useThreshold$set = true;
            return this;
        }

        public ProfanityCheckerBuilder threshold(double threshold) {
            this.threshold$value = threshold;
            this.threshold$set = true;
            return this;
        }

        public ProfanityChecker build() {
            Interpreter interpreter$value = this.interpreter$value;
            if (!this.interpreter$set) {
                interpreter$value = ProfanityChecker.$default$interpreter();
            }
            String libraryPath$value = this.libraryPath$value;
            if (!this.libraryPath$set) {
                libraryPath$value = ProfanityChecker.$default$libraryPath();
            }
            List<Normalizer> normalizers$value = this.normalizers$value;
            if (!this.normalizers$set) {
                normalizers$value = ProfanityChecker.$default$normalizers();
            }
            boolean useThreshold$value = this.useThreshold$value;
            if (!this.useThreshold$set) {
                useThreshold$value = ProfanityChecker.$default$useThreshold();
            }
            double threshold$value = this.threshold$value;
            if (!this.threshold$set) {
                threshold$value = ProfanityChecker.$default$threshold();
            }
            return new ProfanityChecker(interpreter$value, libraryPath$value, normalizers$value, useThreshold$value, threshold$value);
        }

        public String toString() {
            return "ProfanityChecker.ProfanityCheckerBuilder(interpreter$value=" + this.interpreter$value + ", libraryPath$value=" + this.libraryPath$value + ", normalizers$value=" + this.normalizers$value + ", useThreshold$value=" + this.useThreshold$value + ", threshold$value=" + this.threshold$value + ")";
        }
    }
}

