/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.listener;

import java.util.Map;
import java.util.Optional;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.OnlineUser;

public abstract class PlayerListener {
    protected final HuskChat plugin;

    public final void handlePlayerSwitchServer(@NotNull OnlineUser player, @NotNull String newServer) {
        Map<String, String> defaultChannels = this.plugin.getChannels().getServerDefaultChannels();
        if (defaultChannels.containsKey(newServer)) {
            this.plugin.editUserCache(c -> c.switchPlayerChannel(player, (String)defaultChannels.get(newServer), this.plugin));
            return;
        }
        Optional<String> currentChannel = this.plugin.getUserCache().getPlayerChannel(player.getUuid());
        if (currentChannel.isEmpty()) {
            this.plugin.editUserCache(c -> c.switchPlayerChannel(player, this.plugin.getChannels().getDefaultChannel(), this.plugin));
            return;
        }
        this.plugin.getChannels().getChannels().stream().filter(channel -> channel.getId().equalsIgnoreCase((String)currentChannel.get())).findFirst().flatMap(channel -> channel.getRestrictedServers().stream().filter(restrictedServer -> restrictedServer.equalsIgnoreCase(newServer)).findFirst()).ifPresent(restricted -> this.plugin.editUserCache(c -> c.switchPlayerChannel(player, this.plugin.getChannels().getDefaultChannel(), this.plugin)));
    }

    public final void handlePlayerJoin(@NotNull OnlineUser player) {
        this.handlePlayerSwitchServer(player, player.getServerName());
        if (this.plugin.getSettings().getJoinAndQuitMessages().getBroadcastScope() == Channel.BroadcastScope.PASSTHROUGH) {
            return;
        }
        if (this.plugin.getSettings().getJoinAndQuitMessages().getJoin().isEnabled()) {
            this.plugin.getLocales().sendJoinMessage(player, this.plugin);
        }
    }

    public final void handlePlayerQuit(@NotNull OnlineUser player) {
        if (this.plugin.getSettings().getJoinAndQuitMessages().getBroadcastScope() == Channel.BroadcastScope.PASSTHROUGH) {
            return;
        }
        if (this.plugin.getSettings().getJoinAndQuitMessages().getQuit().isEnabled()) {
            this.plugin.getLocales().sendQuitMessage(player, this.plugin);
        }
    }

    public PlayerListener(HuskChat plugin) {
        this.plugin = plugin;
    }
}

