/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import net.william278.huskchat.config.ConfigProvider;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.discord.SpicordHook;
import net.william278.huskchat.discord.WebHook;
import net.william278.huskchat.event.EventProvider;
import net.william278.huskchat.filter.FilterProvider;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.desertwell.util.UpdateChecker;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.util.AudiencesProvider;

public interface HuskChat
extends AudiencesProvider,
ConfigProvider,
FilterProvider,
EventProvider {
    public static final int SPIGOT_RESOURCE_ID = 94496;

    default public void loadDiscordHook() {
        if (this.getSettings().getDiscord().isEnabled()) {
            this.setDiscordHook(this.getSettings().getDiscord().getSpicord().isEnabled() && this.isPluginPresent("Spicord") ? new SpicordHook(this) : new WebHook(this));
        }
    }

    @NotNull
    public List<PlaceholderReplacer> getPlaceholderReplacers();

    default public CompletableFuture<String> replacePlaceholders(@NotNull OnlineUser player, @NotNull String message) {
        CompletionStage<String> future = CompletableFuture.completedFuture(message);
        for (PlaceholderReplacer replacer : this.getPlaceholderReplacers()) {
            future = future.thenComposeAsync(toFormat -> replacer.formatPlaceholders((String)toFormat, player));
        }
        return future;
    }

    @NotNull
    public DataGetter getDataGetter();

    public Optional<DiscordHook> getDiscordHook();

    public void setDiscordHook(@NotNull DiscordHook var1);

    @NotNull
    public Version getVersion();

    @NotNull
    public String getPluginDescription();

    @NotNull
    public String getPlatform();

    public Optional<OnlineUser> getPlayer(@NotNull UUID var1);

    public Optional<OnlineUser> findPlayer(@NotNull String var1);

    @NotNull
    public Collection<OnlineUser> getOnlinePlayers();

    @NotNull
    public Collection<OnlineUser> getOnlinePlayersOnServer(@NotNull OnlineUser var1);

    public boolean isPluginPresent(@NotNull String var1);

    @NotNull
    default public UpdateChecker getUpdateChecker() {
        return UpdateChecker.builder().currentVersion(this.getVersion()).endpoint(UpdateChecker.Endpoint.SPIGOT).resource(Integer.toString(94496)).build();
    }

    default public void checkForUpdates() {
        if (this.getSettings().isCheckForUpdates()) {
            this.getUpdateChecker().check().thenAccept(checked -> {
                if (!checked.isUpToDate()) {
                    this.log(Level.WARNING, "A new version of HuskChat is available: v" + checked.getLatestVersion() + " (running v" + this.getVersion() + ")", new Throwable[0]);
                }
            });
        }
    }

    public void log(@NotNull Level var1, @NotNull String var2, Throwable ... var3);
}

