/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;

@Configuration
public class Channel {
    private String id;
    private String format;
    private BroadcastScope broadcastScope;
    private boolean logToConsole;
    private List<String> restrictedServers;
    private boolean filtered;
    private ChannelPermissions permissions;
    private List<String> shortcutCommands;

    @NotNull
    public List<String> getShortcutCommands() {
        return Settings.formatCommands(this.shortcutCommands);
    }

    public boolean isServerRestricted(@NotNull String server) {
        return this.restrictedServers.stream().anyMatch(server::equalsIgnoreCase);
    }

    public boolean canUserSend(@NotNull OnlineUser user) {
        return this.permissions.getSend().map(node -> user.hasPermission((String)node, false)).orElse(true);
    }

    public boolean canUserReceive(@NotNull OnlineUser user) {
        return this.permissions.getReceive().map(node -> user.hasPermission((String)node, false)).orElse(true);
    }

    private static String $default$format() {
        return "<%sender%> ";
    }

    private static boolean $default$logToConsole() {
        return true;
    }

    private static List<String> $default$restrictedServers() {
        return new ArrayList<String>();
    }

    private static boolean $default$filtered() {
        return true;
    }

    private static ChannelPermissions $default$permissions() {
        return new ChannelPermissions();
    }

    private static List<String> $default$shortcutCommands() {
        return new ArrayList<String>();
    }

    public static ChannelBuilder builder() {
        return new ChannelBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getFormat() {
        return this.format;
    }

    public BroadcastScope getBroadcastScope() {
        return this.broadcastScope;
    }

    public boolean isLogToConsole() {
        return this.logToConsole;
    }

    public List<String> getRestrictedServers() {
        return this.restrictedServers;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public ChannelPermissions getPermissions() {
        return this.permissions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setBroadcastScope(BroadcastScope broadcastScope) {
        this.broadcastScope = broadcastScope;
    }

    public void setLogToConsole(boolean logToConsole) {
        this.logToConsole = logToConsole;
    }

    public void setRestrictedServers(List<String> restrictedServers) {
        this.restrictedServers = restrictedServers;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setPermissions(ChannelPermissions permissions) {
        this.permissions = permissions;
    }

    public void setShortcutCommands(List<String> shortcutCommands) {
        this.shortcutCommands = shortcutCommands;
    }

    private Channel() {
        this.format = Channel.$default$format();
        this.logToConsole = Channel.$default$logToConsole();
        this.restrictedServers = Channel.$default$restrictedServers();
        this.filtered = Channel.$default$filtered();
        this.permissions = Channel.$default$permissions();
        this.shortcutCommands = Channel.$default$shortcutCommands();
    }

    private Channel(String id, String format, BroadcastScope broadcastScope, boolean logToConsole, List<String> restrictedServers, boolean filtered, ChannelPermissions permissions, List<String> shortcutCommands) {
        this.id = id;
        this.format = format;
        this.broadcastScope = broadcastScope;
        this.logToConsole = logToConsole;
        this.restrictedServers = restrictedServers;
        this.filtered = filtered;
        this.permissions = permissions;
        this.shortcutCommands = shortcutCommands;
    }

    @Configuration
    public static class ChannelPermissions {
        @Nullable
        private String send;
        @Nullable
        private String receive;

        public Optional<String> getSend() {
            return Optional.ofNullable(this.send);
        }

        public Optional<String> getReceive() {
            return Optional.ofNullable(this.receive);
        }

        private static String $default$send() {
            return null;
        }

        private static String $default$receive() {
            return null;
        }

        public static ChannelPermissionsBuilder builder() {
            return new ChannelPermissionsBuilder();
        }

        private ChannelPermissions() {
            this.send = ChannelPermissions.$default$send();
            this.receive = ChannelPermissions.$default$receive();
        }

        private ChannelPermissions(@Nullable String send, @Nullable String receive) {
            this.send = send;
            this.receive = receive;
        }

        public void setSend(@Nullable String send) {
            this.send = send;
        }

        public void setReceive(@Nullable String receive) {
            this.receive = receive;
        }

        public static class ChannelPermissionsBuilder {
            private boolean send$set;
            private String send$value;
            private boolean receive$set;
            private String receive$value;

            ChannelPermissionsBuilder() {
            }

            public ChannelPermissionsBuilder send(@Nullable String send) {
                this.send$value = send;
                this.send$set = true;
                return this;
            }

            public ChannelPermissionsBuilder receive(@Nullable String receive) {
                this.receive$value = receive;
                this.receive$set = true;
                return this;
            }

            public ChannelPermissions build() {
                String send$value = this.send$value;
                if (!this.send$set) {
                    send$value = ChannelPermissions.$default$send();
                }
                String receive$value = this.receive$value;
                if (!this.receive$set) {
                    receive$value = ChannelPermissions.$default$receive();
                }
                return new ChannelPermissions(send$value, receive$value);
            }

            public String toString() {
                return "Channel.ChannelPermissions.ChannelPermissionsBuilder(send$value=" + this.send$value + ", receive$value=" + this.receive$value + ")";
            }
        }
    }

    public static class ChannelBuilder {
        private String id;
        private boolean format$set;
        private String format$value;
        private BroadcastScope broadcastScope;
        private boolean logToConsole$set;
        private boolean logToConsole$value;
        private boolean restrictedServers$set;
        private List<String> restrictedServers$value;
        private boolean filtered$set;
        private boolean filtered$value;
        private boolean permissions$set;
        private ChannelPermissions permissions$value;
        private boolean shortcutCommands$set;
        private List<String> shortcutCommands$value;

        ChannelBuilder() {
        }

        public ChannelBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ChannelBuilder format(String format) {
            this.format$value = format;
            this.format$set = true;
            return this;
        }

        public ChannelBuilder broadcastScope(BroadcastScope broadcastScope) {
            this.broadcastScope = broadcastScope;
            return this;
        }

        public ChannelBuilder logToConsole(boolean logToConsole) {
            this.logToConsole$value = logToConsole;
            this.logToConsole$set = true;
            return this;
        }

        public ChannelBuilder restrictedServers(List<String> restrictedServers) {
            this.restrictedServers$value = restrictedServers;
            this.restrictedServers$set = true;
            return this;
        }

        public ChannelBuilder filtered(boolean filtered) {
            this.filtered$value = filtered;
            this.filtered$set = true;
            return this;
        }

        public ChannelBuilder permissions(ChannelPermissions permissions) {
            this.permissions$value = permissions;
            this.permissions$set = true;
            return this;
        }

        public ChannelBuilder shortcutCommands(List<String> shortcutCommands) {
            this.shortcutCommands$value = shortcutCommands;
            this.shortcutCommands$set = true;
            return this;
        }

        public Channel build() {
            String format$value = this.format$value;
            if (!this.format$set) {
                format$value = Channel.$default$format();
            }
            boolean logToConsole$value = this.logToConsole$value;
            if (!this.logToConsole$set) {
                logToConsole$value = Channel.$default$logToConsole();
            }
            List<String> restrictedServers$value = this.restrictedServers$value;
            if (!this.restrictedServers$set) {
                restrictedServers$value = Channel.$default$restrictedServers();
            }
            boolean filtered$value = this.filtered$value;
            if (!this.filtered$set) {
                filtered$value = Channel.$default$filtered();
            }
            ChannelPermissions permissions$value = this.permissions$value;
            if (!this.permissions$set) {
                permissions$value = Channel.$default$permissions();
            }
            List<String> shortcutCommands$value = this.shortcutCommands$value;
            if (!this.shortcutCommands$set) {
                shortcutCommands$value = Channel.$default$shortcutCommands();
            }
            return new Channel(this.id, format$value, this.broadcastScope, logToConsole$value, restrictedServers$value, filtered$value, permissions$value, shortcutCommands$value);
        }

        public String toString() {
            return "Channel.ChannelBuilder(id=" + this.id + ", format$value=" + this.format$value + ", broadcastScope=" + this.broadcastScope + ", logToConsole$value=" + this.logToConsole$value + ", restrictedServers$value=" + this.restrictedServers$value + ", filtered$value=" + this.filtered$value + ", permissions$value=" + this.permissions$value + ", shortcutCommands$value=" + this.shortcutCommands$value + ")";
        }
    }

    public static enum BroadcastScope {
        GLOBAL(false),
        LOCAL(false),
        PASSTHROUGH(true),
        LOCAL_PASSTHROUGH(true),
        GLOBAL_PASSTHROUGH(true);

        private final boolean passThrough;

        public boolean isOneOf(BroadcastScope ... scopes) {
            for (BroadcastScope scope : scopes) {
                if (this != scope) continue;
                return true;
            }
            return false;
        }

        public boolean isPassThrough() {
            return this.passThrough;
        }

        private BroadcastScope(boolean passThrough) {
            this.passThrough = passThrough;
        }
    }
}

