/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;

public class SocialSpyCommand
extends CommandBase {
    public SocialSpyCommand(@NotNull HuskChat plugin) {
        super(plugin.getSettings().getSocialSpy().getSocialspyAliases(), "[color]", plugin);
        this.operatorOnly = true;
    }

    @Override
    public void onExecute(@NotNull OnlineUser player, @NotNull String[] args) {
        if (player instanceof ConsoleUser) {
            this.plugin.getLocales().sendMessage(player, "error_in_game_only", new String[0]);
            return;
        }
        if (args.length == 1) {
            Optional<UserCache.SpyColor> selectedColor = UserCache.SpyColor.getColor(args[0]);
            if (selectedColor.isEmpty()) {
                this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
                return;
            }
            UserCache.SpyColor color = selectedColor.get();
            this.plugin.editUserCache(c -> c.setSocialSpy(player, color));
            this.plugin.getLocales().sendMessage(player, "social_spy_toggled_on_color", color.colorCode, color.name().toLowerCase().replaceAll("_", " "));
            return;
        }
        if (!this.plugin.getUserCache().isSocialSpying(player)) {
            this.plugin.editUserCache(c -> c.setSocialSpy(player));
            this.plugin.getLocales().sendMessage(player, "social_spy_toggled_on", new String[0]);
            return;
        }
        this.plugin.editUserCache(c -> c.removeSocialSpy(player));
        this.plugin.getLocales().sendMessage(player, "social_spy_toggled_off", new String[0]);
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull OnlineUser player, @NotNull String[] args) {
        return Arrays.stream(UserCache.SpyColor.values()).map(Enum::name).map(String::toLowerCase).toList();
    }
}

