/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.listener;

import java.util.Optional;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.listener.PlayerListener;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.user.BungeeUser;

public class BungeeListener
extends PlayerListener
implements Listener {
    public BungeeListener(@NotNull HuskChat plugin) {
        super(plugin);
    }

    @EventHandler(priority=32)
    public void onPlayerChat(ChatEvent e) {
        if (e.isCommand() || e.isProxyCommand() || e.isCancelled()) {
            return;
        }
        BungeeUser player = BungeeUser.adapt((ProxiedPlayer)e.getSender(), this.plugin);
        Optional channel = this.plugin.getUserCache().getPlayerChannel(player.getUuid()).flatMap(channelId -> this.plugin.getChannels().getChannel((String)channelId));
        if (channel.isEmpty()) {
            this.plugin.getLocales().sendMessage(player, "error_no_channel", new String[0]);
            return;
        }
        if (new ChatMessage((Channel)channel.get(), player, e.getMessage(), this.plugin).dispatch()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=32)
    public void onPlayerChangeServer(ServerSwitchEvent e) {
        String server = e.getPlayer().getServer().getInfo().getName();
        BungeeUser player = BungeeUser.adapt(e.getPlayer(), this.plugin);
        this.handlePlayerSwitchServer(player, server);
    }

    @EventHandler
    public void onPlayerJoinNetwork(PostLoginEvent e) {
        super.handlePlayerJoin(BungeeUser.adapt(e.getPlayer(), this.plugin));
    }

    @EventHandler
    public void onPlayerQuitNetwork(PlayerDisconnectEvent e) {
        super.handlePlayerQuit(BungeeUser.adapt(e.getPlayer(), this.plugin));
    }
}

