/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.api.VelocityHuskChatAPI;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.command.VelocityCommand;
import net.william278.huskchat.config.Channels;
import net.william278.huskchat.config.Filters;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.event.VelocityEventProvider;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.bstats.velocity.Metrics;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.listener.VelocityEventChatListener;
import net.william278.huskchat.listener.VelocityPacketChatListener;
import net.william278.huskchat.listener.VelocityPlayerListener;
import net.william278.huskchat.placeholders.DefaultReplacer;
import net.william278.huskchat.placeholders.PAPIProxyBridgeReplacer;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;
import net.william278.huskchat.user.VelocityUser;
import org.slf4j.Logger;

@Plugin(id="huskchat")
public class VelocityHuskChat
implements HuskChat,
VelocityEventProvider {
    private static final int METRICS_ID = 14187;
    private final PluginContainer container;
    private final Logger logger;
    private final Metrics.Factory metrics;
    private final Path configDirectory;
    private final ProxyServer server;
    private final List<ChatFilter> filtersAndReplacers = new ArrayList<ChatFilter>();
    private final List<PlaceholderReplacer> placeholderReplacers = new ArrayList<PlaceholderReplacer>();
    private Settings settings;
    private Locales locales;
    private Channels channels;
    private Filters filterSettings;
    private UserCache.Editor userCache;
    private DiscordHook discordHook;
    private DataGetter dataGetter;

    @Inject
    public VelocityHuskChat(@NotNull ProxyServer server, @NotNull Logger logger, @DataDirectory Path configDirectory, @NotNull Metrics.Factory metrics, @NotNull PluginContainer pluginContainer) {
        this.server = server;
        this.logger = logger;
        this.configDirectory = configDirectory;
        this.metrics = metrics;
        this.container = pluginContainer;
    }

    @Subscribe
    public void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        this.loadConfig();
        this.loadDiscordHook();
        this.dataGetter = this.isPluginPresent("luckperms") ? new LuckPermsDataGetter() : new DefaultDataGetter();
        this.placeholderReplacers.add(new DefaultReplacer(this));
        if (this.getSettings().getPlaceholder().isUsePapi() && this.isPluginPresent("papiproxybridge")) {
            this.placeholderReplacers.add(new PAPIProxyBridgeReplacer(this));
        }
        this.getProxyServer().getEventManager().register((Object)this, (Object)new VelocityPlayerListener(this));
        if (this.getSettings().isUsePacketListening()) {
            new VelocityPacketChatListener(this).register();
        } else {
            this.getProxyServer().getEventManager().register((Object)this, (Object)new VelocityEventChatListener(this));
        }
        VelocityCommand.Type.registerAll(this);
        this.getChannels().getChannels().forEach(channel -> channel.getShortcutCommands().forEach(command -> new VelocityCommand(new ShortcutCommand((String)command, channel.getId(), (HuskChat)this), this)));
        this.getPlugin().log(Level.INFO, String.format("Loaded %s channels with %s associated shortcut commands", this.getChannels().getChannels().size(), this.getChannels().getChannels().stream().mapToInt(channel -> channel.getShortcutCommands().size()).sum()), new Throwable[0]);
        VelocityHuskChatAPI.register(this);
        this.metrics.make(this, 14187);
        this.checkForUpdates();
        this.log(Level.INFO, "Enabled HuskChat version " + this.getVersion(), new Throwable[0]);
    }

    @Override
    public Optional<DiscordHook> getDiscordHook() {
        return Optional.ofNullable(this.discordHook);
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString((String)this.container.getDescription().getVersion().orElseThrow(() -> new IllegalStateException("Could not fetch plugin version from container")));
    }

    @Override
    @NotNull
    public String getPluginDescription() {
        return this.container.getDescription().getDescription().orElse("Unknown");
    }

    @Override
    @NotNull
    public String getPlatform() {
        return "Velocity";
    }

    @Override
    public Optional<OnlineUser> getPlayer(@NotNull UUID uuid) {
        return this.getProxyServer().getPlayer(uuid).map(player -> VelocityUser.adapt(player, this));
    }

    @Override
    @NotNull
    public Collection<OnlineUser> getOnlinePlayers() {
        return this.getProxyServer().getAllPlayers().stream().map(player -> VelocityUser.adapt(player, this)).toList();
    }

    @Override
    @NotNull
    public Collection<OnlineUser> getOnlinePlayersOnServer(@NotNull OnlineUser user) {
        return ((VelocityUser)user).getPlayer().getCurrentServer().map(conn -> conn.getServer().getPlayersConnected().stream().map(player -> VelocityUser.adapt(player, this)).toList()).orElseGet(Collections::emptyList);
    }

    @Override
    public Optional<OnlineUser> findPlayer(@NotNull String username) {
        Optional<OnlineUser> optionalPlayer;
        if (username.isEmpty()) {
            return Optional.empty();
        }
        if (this.getProxyServer().getPlayer(username).isPresent()) {
            Player player = (Player)this.getProxyServer().getPlayer(username).get();
            optionalPlayer = Optional.of(VelocityUser.adapt(player, this));
        } else {
            List<Player> matchedPlayers = this.getProxyServer().matchPlayer(username).stream().filter(val -> val.getUsername().startsWith(username)).sorted().toList();
            optionalPlayer = !matchedPlayers.isEmpty() ? Optional.of(VelocityUser.adapt(matchedPlayers.get(0), this)) : Optional.empty();
        }
        return optionalPlayer;
    }

    @Override
    @Nullable
    public InputStream getResource(@NotNull String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    @Override
    public boolean isPluginPresent(@NotNull String dependency) {
        return this.getProxyServer().getPluginManager().getPlugin(dependency.toLowerCase(Locale.ENGLISH)).isPresent();
    }

    @Override
    @NotNull
    public ProxyServer getProxyServer() {
        return this.server;
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        switch (level.getName()) {
            case "SEVERE": {
                if (exceptions.length > 0) {
                    this.logger.error(message, exceptions[0]);
                    break;
                }
                this.logger.error(message);
                break;
            }
            case "WARNING": {
                if (exceptions.length > 0) {
                    this.logger.warn(message, exceptions[0]);
                    break;
                }
                this.logger.warn(message);
                break;
            }
            default: {
                this.logger.info(message);
            }
        }
    }

    @Override
    @NotNull
    public Audience getAudience(@NotNull UUID user) {
        return this.getProxyServer().getPlayer(user).map(player -> player).orElse(Audience.empty());
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.getProxyServer().getConsoleCommandSource();
    }

    @Override
    @NotNull
    public HuskChat getPlugin() {
        return this;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Metrics.Factory getMetrics() {
        return this.metrics;
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    public List<ChatFilter> getFiltersAndReplacers() {
        return this.filtersAndReplacers;
    }

    @Override
    public List<PlaceholderReplacer> getPlaceholderReplacers() {
        return this.placeholderReplacers;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public Channels getChannels() {
        return this.channels;
    }

    @Override
    public Filters getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public UserCache.Editor getUserCache() {
        return this.userCache;
    }

    @Override
    public DataGetter getDataGetter() {
        return this.dataGetter;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Override
    public void setChannels(Channels channels) {
        this.channels = channels;
    }

    @Override
    public void setFilterSettings(Filters filterSettings) {
        this.filterSettings = filterSettings;
    }

    @Override
    public void setUserCache(UserCache.Editor userCache) {
        this.userCache = userCache;
    }

    @Override
    public void setDiscordHook(DiscordHook discordHook) {
        this.discordHook = discordHook;
    }
}

