/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.regex.Pattern;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.OnlineUser;

public class AdvertisingFilterer
extends ChatFilter {
    private final Pattern domainPattern = Pattern.compile("^(?:(?:(?:https?|ftp):)?//)?(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4])|(?:(?:[a-z0-9\\u00a1-\\uffff][a-z0-9\\u00a1-\\uffff_-]{0,62})?[a-z0-9\\u00a1-\\uffff]\\.)+[a-z\\u00a1-\\uffff]{2,}\\.?)(?::\\d{2,5})?(?:[/?#]\\S*)?$", 2);

    public AdvertisingFilterer(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new ChatFilter.FilterSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser player, @NotNull String message) {
        return !this.domainPattern.matcher(message).matches();
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_advertising";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.advertising";
    }
}

