/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.event;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.william278.huskchat.BukkitHuskChat;
import net.william278.huskchat.event.BroadcastMessageEvent;
import net.william278.huskchat.event.BukkitBroadcastMessageEvent;
import net.william278.huskchat.event.BukkitChatMessageEvent;
import net.william278.huskchat.event.BukkitPrivateMessageEvent;
import net.william278.huskchat.event.ChatMessageEvent;
import net.william278.huskchat.event.EventProvider;
import net.william278.huskchat.event.PrivateMessageEvent;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.OnlineUser;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public interface BukkitEventProvider
extends EventProvider {
    @Override
    default public CompletableFuture<ChatMessageEvent> fireChatMessageEvent(@NotNull OnlineUser player, @NotNull String message, @NotNull String channelId) {
        CompletableFuture<ChatMessageEvent> completableFuture = new CompletableFuture<ChatMessageEvent>();
        BukkitChatMessageEvent event = new BukkitChatMessageEvent(player, message, channelId);
        this.getPlugin().getServer().getScheduler().runTask((Plugin)this.getPlugin(), () -> {
            this.getPlugin().getServer().getPluginManager().callEvent((Event)event);
            completableFuture.complete(event);
        });
        return completableFuture;
    }

    @Override
    default public CompletableFuture<PrivateMessageEvent> firePrivateMessageEvent(@NotNull OnlineUser sender, @NotNull List<OnlineUser> receivers, @NotNull String message) {
        CompletableFuture<PrivateMessageEvent> completableFuture = new CompletableFuture<PrivateMessageEvent>();
        BukkitPrivateMessageEvent event = new BukkitPrivateMessageEvent(sender, receivers, message);
        this.getPlugin().getServer().getScheduler().runTask((Plugin)this.getPlugin(), () -> {
            this.getPlugin().getServer().getPluginManager().callEvent((Event)event);
            completableFuture.complete(event);
        });
        return completableFuture;
    }

    @Override
    default public CompletableFuture<BroadcastMessageEvent> fireBroadcastMessageEvent(@NotNull OnlineUser sender, @NotNull String message) {
        CompletableFuture<BroadcastMessageEvent> completableFuture = new CompletableFuture<BroadcastMessageEvent>();
        BukkitBroadcastMessageEvent event = new BukkitBroadcastMessageEvent(sender, message);
        this.getPlugin().getServer().getScheduler().runTask((Plugin)this.getPlugin(), () -> {
            this.getPlugin().getServer().getPluginManager().callEvent((Event)event);
            completableFuture.complete(event);
        });
        return completableFuture;
    }

    public BukkitHuskChat getPlugin();
}

