/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.william278.huskchat.filter.AdvertisingFilterer;
import net.william278.huskchat.filter.AsciiFilter;
import net.william278.huskchat.filter.CapsFilter;
import net.william278.huskchat.filter.EmojiReplacer;
import net.william278.huskchat.filter.ProfanityFilterer;
import net.william278.huskchat.filter.RegexFilter;
import net.william278.huskchat.filter.RepeatFilter;
import net.william278.huskchat.filter.SpamFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.libraries.configlib.Polymorphic;
import net.william278.huskchat.libraries.configlib.PolymorphicTypes;
import net.william278.huskchat.user.OnlineUser;

public abstract class ChatFilter {
    protected final FilterSettings settings;

    public abstract boolean isAllowed(@NotNull OnlineUser var1, @NotNull String var2);

    @NotNull
    public abstract String getDisallowedLocale();

    @NotNull
    public abstract String getIgnorePermission();

    public FilterSettings getSettings() {
        return this.settings;
    }

    public ChatFilter(FilterSettings settings) {
        this.settings = settings;
    }

    @Configuration
    @Polymorphic
    @PolymorphicTypes(value={@PolymorphicTypes.Type(type=FilterSettings.class, alias="filter"), @PolymorphicTypes.Type(type=CapsFilter.CapsFilterSettings.class, alias="caps"), @PolymorphicTypes.Type(type=ProfanityFilterer.ProfanityFilterSettings.class, alias="profanity"), @PolymorphicTypes.Type(type=SpamFilter.SpamFilterSettings.class, alias="spam"), @PolymorphicTypes.Type(type=RepeatFilter.RepeatFilterSettings.class, alias="repeat"), @PolymorphicTypes.Type(type=RegexFilter.RegexFilterSettings.class, alias="regex"), @PolymorphicTypes.Type(type=EmojiReplacer.EmojiReplacerSettings.class, alias="emoji")})
    public static class FilterSettings {
        protected boolean enabled = true;
        private List<String> channels = List.of("global", "local");
        private boolean privateMessages = true;
        private boolean broadcastMessages = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<String> getChannels() {
            return this.channels;
        }

        public boolean isPrivateMessages() {
            return this.privateMessages;
        }

        public boolean isBroadcastMessages() {
            return this.broadcastMessages;
        }

        FilterSettings() {
        }
    }

    public static abstract class ReplacerFilter
    extends ChatFilter {
        public ReplacerFilter(@NotNull FilterSettings settings) {
            super(settings);
        }

        @NotNull
        public abstract String replace(@NotNull String var1);
    }

    public static enum Type {
        ADVERTISING(AdvertisingFilterer.getDefaultSettings(), AdvertisingFilterer::new),
        CAPS(CapsFilter.getDefaultSettings(), CapsFilter::new),
        SPAM(SpamFilter.getDefaultSettings(), SpamFilter::new),
        PROFANITY(ProfanityFilterer.getDefaultSettings(), ProfanityFilterer::new),
        REPEAT(RepeatFilter.getDefaultSettings(), RepeatFilter::new),
        ASCII(AsciiFilter.getDefaultSettings(), AsciiFilter::new),
        REGEX(RegexFilter.getDefaultSettings(), RegexFilter::new),
        EMOJI(EmojiReplacer.getDefaultSettings(), EmojiReplacer::new);

        private final FilterSettings defaultSettings;
        private final Function<FilterSettings, ChatFilter> creator;

        @NotNull
        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public FilterSettings getDefaultSettings() {
            return this.defaultSettings;
        }

        public Function<FilterSettings, ChatFilter> getCreator() {
            return this.creator;
        }

        private Type(FilterSettings defaultSettings, Function<FilterSettings, ChatFilter> creator) {
            this.defaultSettings = defaultSettings;
            this.creator = creator;
        }
    }
}

