/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Filters;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.OnlineUser;

public interface FilterProvider {
    public List<ChatFilter> getFiltersAndReplacers();

    default public void loadFilters() {
        Filters settings = this.getPlugin().getFilterSettings();
        settings.getFilters().entrySet().stream().filter(entry -> ((ChatFilter.FilterSettings)entry.getValue()).isEnabled()).forEach(entry -> {
            ChatFilter.Type type = (ChatFilter.Type)((Object)((Object)entry.getKey()));
            ChatFilter.FilterSettings filterSettings = (ChatFilter.FilterSettings)entry.getValue();
            this.getFiltersAndReplacers().add(type.getCreator().apply(filterSettings));
            this.getPlugin().log(Level.INFO, "Loaded %s filter".formatted(type.name()), new Throwable[0]);
        });
    }

    default public Optional<String> filter(@NotNull OnlineUser sender, @NotNull String message, @NotNull List<ChatFilter> filters) {
        boolean bypass = sender.hasPermission("huskchat.bypass_filters", false);
        StringBuilder filtered = new StringBuilder(message);
        for (ChatFilter filter : filters) {
            if (sender.hasPermission(filter.getIgnorePermission(), false)) continue;
            if (filter instanceof ChatFilter.ReplacerFilter) {
                ChatFilter.ReplacerFilter replacer = (ChatFilter.ReplacerFilter)filter;
                filtered.replace(0, filtered.length(), replacer.replace(filtered.toString()));
            }
            if (bypass || filter.isAllowed(sender, message)) continue;
            this.getPlugin().getLocales().sendMessage(sender, filter.getDisallowedLocale(), new String[0]);
            return Optional.empty();
        }
        return Optional.of(filtered.toString());
    }

    default public List<ChatFilter> getChannelFilters(@NotNull Channel channel) {
        return this.getFiltersAndReplacers().stream().filter(filter -> filter.getSettings().getChannels().contains(channel.getId())).toList();
    }

    default public List<ChatFilter> getMessageFilters() {
        return this.getFiltersAndReplacers().stream().filter(filter -> filter.getSettings().isPrivateMessages()).toList();
    }

    default public List<ChatFilter> getBroadcastFilters() {
        return this.getFiltersAndReplacers().stream().filter(filter -> filter.getSettings().isBroadcastMessages()).toList();
    }

    @NotNull
    public HuskChat getPlugin();
}

