/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling;

import net.william278.huskchat.libraries.annotations.Contract;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.MorePaperLib;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.AsynchronousScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.AttachedScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.BukkitSchedulerAsAsynchronousScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.BukkitSchedulerAsRegionalScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.EntitySpecificScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.FoliaDetection;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.GlobalAsyncScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.GlobalScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.RegionSpecificScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.RegionalScheduler;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.scheduling.StandardFoliaDetection;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class GracefulScheduling {
    private final MorePaperLib morePaperLib;
    private final FoliaDetection foliaDetection;

    public GracefulScheduling(MorePaperLib morePaperLib, FoliaDetection foliaDetection) {
        this.morePaperLib = morePaperLib;
        this.foliaDetection = foliaDetection;
    }

    public GracefulScheduling(MorePaperLib morePaperLib) {
        this(morePaperLib, StandardFoliaDetection.INSTANCE);
    }

    public boolean isUsingFolia() {
        return this.foliaDetection.isUsingFolia();
    }

    @Contract(value="-> new", pure=true)
    public AsynchronousScheduler asyncScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalAsyncScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsAsynchronousScheduler(this.morePaperLib);
    }

    @Contract(value="-> new", pure=true)
    public RegionalScheduler globalRegionalScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    @Contract(value="_ -> new", pure=true)
    public RegionalScheduler regionSpecificScheduler(Location location) {
        return this.regionSpecificScheduler(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public RegionalScheduler regionSpecificScheduler(World world, int chunkX, int chunkZ) {
        if (this.isUsingFolia()) {
            return new RegionSpecificScheduler(this.morePaperLib.getPlugin(), world, chunkX, chunkZ);
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    @Contract(value="_ -> new", pure=true)
    public AttachedScheduler entitySpecificScheduler(Entity entity) {
        if (this.isUsingFolia()) {
            return new EntitySpecificScheduler(entity, this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).asAttachedScheduler();
    }

    public boolean isOnGlobalRegionThread() {
        Server server = this.morePaperLib.getPlugin().getServer();
        if (this.isUsingFolia()) {
            return server.isGlobalTickThread();
        }
        return server.isPrimaryThread();
    }

    public void cancelGlobalTasks() {
        if (this.isUsingFolia()) {
            new GlobalAsyncScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            new GlobalScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            return;
        }
        new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).cancelTasks();
    }
}

