/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;

public class PrivateMessage {
    private final HuskChat plugin;
    private final Settings.MessageSettings settings;
    private final List<String> targetUsernames;
    private final String message;
    private OnlineUser sender;

    public PrivateMessage(@NotNull OnlineUser sender, @NotNull List<String> targetUsernames, @NotNull String message, @NotNull HuskChat plugin) {
        this.sender = sender;
        this.targetUsernames = targetUsernames;
        this.message = message;
        this.plugin = plugin;
        this.settings = plugin.getSettings().getMessageCommand();
    }

    public void dispatch() {
        for (String restrictedServer : this.settings.getRestrictedServers()) {
            if (!restrictedServer.equalsIgnoreCase(this.sender.getServerName())) continue;
            this.plugin.getLocales().sendMessage(this.sender, "error_message_restricted_server", new String[0]);
            return;
        }
        if (this.targetUsernames.size() > 1 && !this.settings.getGroupMessages().isEnabled()) {
            this.plugin.getLocales().sendMessage(this.sender, "error_group_messages_disabled", new String[0]);
            return;
        }
        ArrayList<OnlineUser> targetPlayers = new ArrayList<OnlineUser>();
        HashSet<UUID> targetUUIDs = new HashSet<UUID>();
        for (String targetUsername : this.targetUsernames) {
            Optional<OnlineUser> targetPlayer = ConsoleUser.isConsolePlayer(targetUsername) ? Optional.of(ConsoleUser.wrap(this.plugin)) : this.plugin.findPlayer(targetUsername);
            if (!targetPlayer.isPresent() || targetUUIDs.contains(targetPlayer.get().getUuid())) continue;
            targetPlayers.add(targetPlayer.get());
            targetUUIDs.add(targetPlayer.get().getUuid());
        }
        targetUUIDs.remove(this.sender.getUuid());
        if (targetUUIDs.isEmpty()) {
            this.plugin.getLocales().sendMessage(this.sender, "error_cannot_message_self", new String[0]);
            return;
        }
        int maxGroupMembers = this.settings.getGroupMessages().getMaxSize();
        if (targetPlayers.size() > maxGroupMembers) {
            this.plugin.getLocales().sendMessage(this.sender, "error_group_messages_max", Integer.toString(maxGroupMembers));
            return;
        }
        if (targetPlayers.isEmpty()) {
            if (this.targetUsernames.size() > 1) {
                this.plugin.getLocales().sendMessage(this.sender, "error_players_not_found", new String[0]);
            } else {
                this.plugin.getLocales().sendMessage(this.sender, "error_player_not_found", new String[0]);
            }
            return;
        }
        Optional<String> filtered = this.plugin.filter(this.sender, this.message, this.plugin.getMessageFilters());
        if (filtered.isEmpty()) {
            return;
        }
        AtomicReference<String> finalMessage = new AtomicReference<String>(filtered.get());
        this.plugin.firePrivateMessageEvent(this.sender, targetPlayers, finalMessage.get()).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.sender = event.getSender();
            List<OnlineUser> receivers = event.getRecipients();
            finalMessage.set(event.getMessage());
            this.plugin.editUserCache(c -> c.setLastMessenger(this.sender.getUuid(), receivers));
            this.plugin.getLocales().sendOutboundPrivateMessage(this.sender, receivers, (String)finalMessage.get(), this.plugin);
            this.plugin.editUserCache(c -> receivers.forEach(target -> {
                ArrayList<OnlineUser> receivedMessageFrom = new ArrayList<OnlineUser>(receivers);
                receivedMessageFrom.removeIf(player -> player.getUuid().equals(target.getUuid()));
                receivedMessageFrom.add(0, this.sender);
                c.setLastMessenger(target.getUuid(), receivedMessageFrom);
            }));
            this.plugin.getLocales().sendInboundPrivateMessage(receivers, this.sender, (String)finalMessage.get(), this.plugin);
            if (this.plugin.getSettings().getSocialSpy().isEnabled() && !this.sender.hasPermission("huskchat.command.socialspy.bypass", false) && !((OnlineUser)receivers.stream().findFirst().orElseThrow(() -> new IllegalStateException("No receivers available for message"))).hasPermission("huskchat.command.socialspy.bypass", false)) {
                Map<OnlineUser, UserCache.SpyColor> spies = this.plugin.getUserCache().getSocialSpies(receivers, this.plugin);
                for (OnlineUser spy : spies.keySet()) {
                    if (spy.getUuid().equals(this.sender.getUuid())) continue;
                    if (!spy.hasPermission("huskchat.command.socialspy", false)) {
                        this.plugin.editUserCache(c -> c.removeSocialSpy(spy));
                        continue;
                    }
                    UserCache.SpyColor color = spies.get(spy);
                    this.plugin.getLocales().sendSocialSpy(spy, color, this.sender, receivers, (String)finalMessage.get(), this.plugin);
                }
            }
            if (this.settings.isLogToConsole()) {
                StringJoiner formattedPlayers = new StringJoiner(", ");
                for (OnlineUser player : receivers) {
                    formattedPlayers.add(player.getName());
                }
                String logFormat = this.settings.getLogFormat().replaceAll("%sender%", this.sender.getName()).replaceAll("%receiver%", formattedPlayers.toString());
                this.plugin.log(Level.INFO, logFormat + finalMessage, new Throwable[0]);
            }
        });
    }
}

