/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;

public class SpamFilter
extends ChatFilter {
    private final HashMap<UUID, LinkedList<Long>> userMessageQueues = new HashMap();

    public SpamFilter(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new SpamFilterSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser player, @NotNull String message) {
        if (!this.userMessageQueues.containsKey(player.getUuid())) {
            this.userMessageQueues.put(player.getUuid(), new LinkedList());
        }
        long currentTimestamp = Instant.now().getEpochSecond();
        if (!this.userMessageQueues.get(player.getUuid()).isEmpty()) {
            SpamFilterSettings spam = (SpamFilterSettings)this.settings;
            if (currentTimestamp > this.userMessageQueues.get(player.getUuid()).getLast() + (long)spam.getPeriodSeconds()) {
                this.userMessageQueues.get(player.getUuid()).removeLast();
            }
            if (this.userMessageQueues.get(player.getUuid()).size() > spam.getMessagesPerPeriod()) {
                return false;
            }
        }
        this.userMessageQueues.get(player.getUuid()).addFirst(currentTimestamp);
        return true;
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_spam";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.spam";
    }

    @Configuration
    public static class SpamFilterSettings
    extends ChatFilter.FilterSettings {
        public int periodSeconds = 4;
        public int messagesPerPeriod = 3;

        public int getPeriodSeconds() {
            return this.periodSeconds;
        }

        public int getMessagesPerPeriod() {
            return this.messagesPerPeriod;
        }

        private SpamFilterSettings() {
        }
    }
}

