/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import java.util.Optional;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.user.OnlineUser;

public class BungeeUser
extends OnlineUser {
    private final ProxiedPlayer player;

    private BungeeUser(@NotNull ProxiedPlayer player, @NotNull HuskChat plugin) {
        super(player.getName(), player.getUniqueId(), plugin);
        this.player = player;
    }

    @NotNull
    public static BungeeUser adapt(@NotNull ProxiedPlayer player, @NotNull HuskChat plugin) {
        return new BungeeUser(player, plugin);
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.getConnectedTo().map(s -> s.getInfo().getName()).orElse("unknown");
    }

    @Override
    public int getPlayersOnServer() {
        return this.getConnectedTo().map(s -> s.getInfo().getPlayers().size()).orElse(0);
    }

    private Optional<Server> getConnectedTo() {
        return Optional.ofNullable(this.player.getServer());
    }

    @Override
    public boolean hasPermission(@Nullable String node, boolean allowByDefault) {
        if (node != null && this.player.getPermissions().contains(node)) {
            return this.player.hasPermission(node);
        }
        return allowByDefault;
    }

    @NotNull
    public ProxiedPlayer getPlayer() {
        return this.player;
    }
}

