/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.getter;

import java.util.Optional;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.User;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.OnlineUser;

public class BungeePermsDataGetter
extends DataGetter {
    private final PermissionsManager permissionsManager = BungeePerms.getInstance().getPermissionsManager();

    @Override
    public String getPlayerFullName(@NotNull OnlineUser player) {
        Optional<String> prefix = this.getPlayerPrefix(player);
        Optional<String> suffix = this.getPlayerSuffix(player);
        return (prefix.isPresent() ? prefix : "") + player.getName() + (suffix.isPresent() ? suffix : "");
    }

    @Override
    public String getPlayerName(@NotNull OnlineUser player) {
        return player.getName();
    }

    @Override
    public Optional<String> getPlayerPrefix(@NotNull OnlineUser player) {
        try {
            return Optional.of(this.permissionsManager.getMainGroup(this.getUser(player)).getPrefix());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getPlayerSuffix(@NotNull OnlineUser player) {
        try {
            return Optional.of(this.permissionsManager.getMainGroup(this.getUser(player)).getSuffix());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getPlayerGroupName(@NotNull OnlineUser player) {
        try {
            return Optional.of(this.permissionsManager.getMainGroup(this.getUser(player)).getName());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getPlayerGroupDisplayName(@NotNull OnlineUser player) {
        try {
            return Optional.of(this.permissionsManager.getMainGroup(this.getUser(player)).getDisplay());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getTextFromNode(@NotNull OnlineUser player, @NotNull String nodePrefix) {
        Object prefix = nodePrefix.endsWith(".") ? nodePrefix : nodePrefix + ".";
        return this.getUser(player).getPerms().stream().filter(arg_0 -> BungeePermsDataGetter.lambda$getTextFromNode$0((String)prefix, arg_0)).findFirst().map(arg_0 -> BungeePermsDataGetter.lambda$getTextFromNode$1((String)prefix, arg_0));
    }

    private User getUser(OnlineUser player) {
        return this.permissionsManager.getUser(player.getUuid());
    }

    private static /* synthetic */ String lambda$getTextFromNode$1(String prefix, String node) {
        return node.length() > prefix.length() ? node.substring(prefix.length()) : "";
    }

    private static /* synthetic */ boolean lambda$getTextFromNode$0(String prefix, String node) {
        return node.startsWith(prefix);
    }
}

