/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.configlib.Comment;
import net.william278.huskchat.libraries.configlib.Configuration;

@Configuration
public class Channels {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskChat - Channels     \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskchat/\n\u2517\u2578 Channels Help: https://william278.net/docs/huskchat/channels/";
    @Comment(value={"The default chat channel players are placed in (can be overridden by server_default_channels)"})
    private String defaultChannel = "global";
    @Comment(value={"Map of server names to a channel players will be automatically moved into when they join that server"})
    private Map<String, String> serverDefaultChannels = Map.of("example", "global");
    @Comment(value={"The format of log messages (applies to channels with logging enabled)"})
    private String channelLogFormat = "[CHAT] [%channel%] %sender%: ";
    @Comment(value={"Aliases for the /channel command"})
    private List<String> channelCommandAliases = List.of("channel", "c");
    @Comment(value={"Channel definitions"})
    private List<Channel> channels = List.of(Channel.builder().id("local").format("%fullname%&r&f: ").broadcastScope(Channel.BroadcastScope.LOCAL).shortcutCommands(List.of("/local", "/l")).build(), Channel.builder().id("global").format("&#00fb9a&[G]&r&f %fullname%&r&f: ").broadcastScope(Channel.BroadcastScope.GLOBAL).shortcutCommands(List.of("/global", "/g")).build(), Channel.builder().id("staff").format("&e[Staff] %name%: &7").broadcastScope(Channel.BroadcastScope.GLOBAL).filtered(false).permissions(Channel.ChannelPermissions.builder().send("huskchat.channel.staff.send").receive("huskchat.channel.staff.receive").build()).shortcutCommands(List.of("/staff", "/sc")).build(), Channel.builder().id("helpop").format("&#00fb9a&[HelpOp] %name%:&7").broadcastScope(Channel.BroadcastScope.GLOBAL).filtered(false).permissions(Channel.ChannelPermissions.builder().receive("huskchat.channel.helpop.receive").build()).shortcutCommands(List.of("/helpop", "/helpme")).build());

    public Optional<Channel> getChannel(@Nullable String channelId) {
        if (channelId == null) {
            return Optional.empty();
        }
        return this.channels.stream().filter(channel -> channel.getId().equalsIgnoreCase(channelId)).findFirst();
    }

    @NotNull
    public List<String> getChannelCommandAliases() {
        return Settings.formatCommands(this.channelCommandAliases);
    }

    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    public Map<String, String> getServerDefaultChannels() {
        return this.serverDefaultChannels;
    }

    public String getChannelLogFormat() {
        return this.channelLogFormat;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    private Channels() {
    }
}

