/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.libraries.minedown.adventure.MineDownParser;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;

@Configuration
public class Locales {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskChat - Locales      \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 See plugin about menu for international locale credits\n\u2523\u2578 Formatted in MineDown: https://github.com/Phoenix616/MineDown\n\u2517\u2578 Translate HuskClaims: https://william278.net/docs/huskchat/translations";
    private static final String SILENT_JOIN_PERMISSION = "huskchat.silent_join";
    private static final String SILENT_QUIT_PERMISSION = "huskchat.silent_quit";
    private static final String FORMATTED_CHAT_PERMISSION = "huskchat.formatted_chat";
    static final String DEFAULT_LOCALE = "en-gb";
    Map<String, String> locales = new TreeMap<String, String>();

    @Nullable
    public String getRawLocale(@NotNull String id) {
        return this.locales.get(id);
    }

    public void sendMessage(@NotNull OnlineUser player, @NotNull String id, String ... replacements) {
        String locale = this.getRawLocale(id);
        if (locale == null || locale.isEmpty()) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : replacements) {
            String replacementString = "%" + replacementIndexer + "%";
            locale = locale.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        player.sendMessage(new MineDown(locale));
    }

    public void sendChannelMessage(@NotNull OnlineUser target, @NotNull OnlineUser sender, @NotNull Channel channel, @NotNull String message, @NotNull HuskChat plugin) {
        plugin.replacePlaceholders(sender, channel.getFormat()).thenAccept(replaced -> {
            Component format = new MineDown((String)replaced).toComponent();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(format);
            if (sender.hasPermission(FORMATTED_CHAT_PERMISSION, false)) {
                builder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent().color(this.getFormatColor(format)));
            } else {
                builder.append(Component.text(message).color(this.getFormatColor(format)));
            }
            target.sendMessage((Component)builder.build());
        });
    }

    public void sendOutboundPrivateMessage(@NotNull OnlineUser sender, @NotNull List<OnlineUser> recipients, @NotNull String message, @NotNull HuskChat plugin) {
        plugin.replacePlaceholders(recipients.get(0), recipients.size() == 1 ? plugin.getSettings().getMessageCommand().getFormat().getOutbound() : plugin.getSettings().getMessageCommand().getFormat().getGroupOutbound()).thenAccept(replaced -> {
            if (recipients.size() > 1) {
                replaced = replaced.replace("%group_amount_subscript%", this.superscriptNumber(recipients.size() - 1)).replace("%group_amount%", Integer.toString(recipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(recipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(recipients, "\n")));
            }
            TextComponent.Builder builder = Component.text();
            Component format = new MineDown((String)replaced).toComponent();
            builder.append(format);
            if (sender.hasPermission(FORMATTED_CHAT_PERMISSION, false)) {
                builder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent().color(this.getFormatColor(format)));
            } else {
                builder.append(Component.text(message).color(this.getFormatColor(format)));
            }
            sender.sendMessage((Component)builder.build());
        });
    }

    @Nullable
    private TextColor getFormatColor(@NotNull Component component) {
        TextColor color = component.color();
        if (component.children().isEmpty()) {
            return color;
        }
        for (Component child : component.children()) {
            TextColor childColor = this.getFormatColor(child);
            if (childColor == null) continue;
            color = childColor;
        }
        return color;
    }

    public void sendInboundPrivateMessage(@NotNull List<OnlineUser> recipients, @NotNull OnlineUser sender, @NotNull String message, @NotNull HuskChat plugin) {
        plugin.replacePlaceholders(sender, recipients.size() == 1 ? plugin.getSettings().getMessageCommand().getFormat().getInbound() : plugin.getSettings().getMessageCommand().getFormat().getGroupInbound()).thenAccept(replaced -> {
            if (recipients.size() > 1) {
                replaced = replaced.replace("%group_amount_subscript%", this.superscriptNumber(recipients.size() - 1)).replace("%group_amount%", Integer.toString(recipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(recipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(recipients, "\n")));
            }
            TextComponent.Builder builder = Component.text();
            Component format = new MineDown((String)replaced).toComponent();
            builder.append(format);
            if (sender.hasPermission(FORMATTED_CHAT_PERMISSION, false)) {
                builder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent().color(this.getFormatColor(format)));
            } else {
                builder.append(Component.text(message).color(this.getFormatColor(format)));
            }
            for (OnlineUser recipient : recipients) {
                recipient.sendMessage((Component)builder.build());
            }
        });
    }

    public void sendLocalSpy(@NotNull OnlineUser spy, @NotNull UserCache.SpyColor spyColor, @NotNull OnlineUser sender, @NotNull Channel channel, @NotNull String message, @NotNull HuskChat plugin) {
        plugin.replacePlaceholders(sender, plugin.getSettings().getLocalSpy().getFormat()).thenAccept(replaced -> {
            TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().append(new MineDown(replaced.replace("%spy_color%", spyColor.colorCode).replace("%channel%", channel.getId()) + MineDown.escape(message)).toComponent());
            spy.sendMessage((Component)componentBuilder.build());
        });
    }

    public void sendSocialSpy(@NotNull OnlineUser spy, @NotNull UserCache.SpyColor spyColor, @NotNull OnlineUser sender, @NotNull List<OnlineUser> receivers, @NotNull String message, @NotNull HuskChat plugin) {
        plugin.replacePlaceholders(sender, receivers.size() == 1 ? plugin.getSettings().getSocialSpy().getFormat() : plugin.getSettings().getSocialSpy().getGroupFormat().replace("%sender_", "%")).thenAccept(senderReplaced -> plugin.replacePlaceholders((OnlineUser)receivers.get(0), senderReplaced.replace("%receiver_", "%")).thenAccept(replaced -> {
            if (receivers.size() > 1) {
                replaced = replaced.replace("%group_amount_subscript%", this.superscriptNumber(receivers.size() - 1)).replace("%group_amount%", Integer.toString(receivers.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(receivers, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(receivers, "\n")));
            }
            spy.sendMessage(new MineDown(replaced.replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message)));
        }));
    }

    public void sendJoinMessage(@NotNull OnlineUser player, @NotNull HuskChat plugin) {
        if (player.hasPermission(SILENT_JOIN_PERMISSION, false)) {
            return;
        }
        plugin.replacePlaceholders(player, plugin.getDataGetter().getTextFromNode(player, "huskchat.join_message").orElse(plugin.getSettings().getJoinAndQuitMessages().getJoin().getFormat())).thenAccept(replaced -> this.sendJoinQuitMessage(player, new MineDown((String)replaced).toComponent(), plugin));
    }

    public void sendQuitMessage(@NotNull OnlineUser player, @NotNull HuskChat plugin) {
        if (player.hasPermission(SILENT_QUIT_PERMISSION, false)) {
            return;
        }
        plugin.replacePlaceholders(player, plugin.getDataGetter().getTextFromNode(player, "huskchat.quit_message").orElse(plugin.getSettings().getJoinAndQuitMessages().getQuit().getFormat())).thenAccept(replaced -> this.sendJoinQuitMessage(player, new MineDown((String)replaced).toComponent(), plugin));
    }

    private void sendJoinQuitMessage(@NotNull OnlineUser player, @NotNull Component component, @NotNull HuskChat plugin) {
        boolean local = List.of(Channel.BroadcastScope.LOCAL, Channel.BroadcastScope.LOCAL_PASSTHROUGH).contains((Object)plugin.getSettings().getJoinAndQuitMessages().getBroadcastScope());
        for (OnlineUser online : plugin.getOnlinePlayers()) {
            if (local && !online.getServerName().equals(player.getServerName())) continue;
            online.sendMessage(component);
        }
    }

    @NotNull
    public final String getGroupMemberList(@NotNull List<OnlineUser> players, @NotNull String delimiter) {
        StringJoiner memberList = new StringJoiner(delimiter);
        for (OnlineUser player : players) {
            memberList.add(player.getName());
        }
        return memberList.toString();
    }

    @NotNull
    public final String superscriptNumber(int number) {
        String[] digits = new String[]{"\u2080", "\u2081", "\u2082", "\u2083", "\u2084", "\u2085", "\u2086", "\u2087", "\u2088", "\u2089"};
        StringBuilder sb = new StringBuilder();
        for (char c : String.valueOf(number).toCharArray()) {
            sb.append(digits[Integer.parseInt(String.valueOf(c))]);
        }
        return sb.toString();
    }

    public Map<String, String> getLocales() {
        return this.locales;
    }

    private Locales() {
    }
}

