/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.regex.Pattern;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.OnlineUser;

public class AsciiFilter
extends ChatFilter {
    private final Pattern asciiPattern = Pattern.compile("^[\\u0000-\\u007F]*$");

    public AsciiFilter(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new ChatFilter.FilterSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser player, @NotNull String message) {
        return this.asciiPattern.matcher(message).matches();
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_ascii";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.ascii";
    }
}

