/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.listener;

import com.google.common.collect.Sets;
import com.velocitypowered.api.event.AwaitingEventExecutor;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.VelocityHuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.desertwell.util.ThrowingConsumer;
import net.william278.huskchat.listener.VelocityChatListener;

public class VelocityPacketChatListener {
    private static final String KEY = "huskchat";
    private final VelocityHuskChat plugin;
    private final Set<UUID> huskChatEntries;

    public VelocityPacketChatListener(@NotNull VelocityHuskChat plugin) {
        this.plugin = plugin;
        this.huskChatEntries = Sets.newConcurrentHashSet();
    }

    public void register() {
        this.loadPlayers();
        this.loadListeners();
    }

    private void loadPlayers() {
        this.plugin.getServer().getAllPlayers().forEach(this::injectPlayer);
    }

    private void loadListeners() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, PostLoginEvent.class, (EventHandler)((AwaitingEventExecutor)postLoginEvent -> EventTask.withContinuation(continuation -> {
            this.injectPlayer(postLoginEvent.getPlayer());
            continuation.resume();
        })));
        this.plugin.getServer().getEventManager().register((Object)this.plugin, DisconnectEvent.class, (EventHandler)((AwaitingEventExecutor)disconnectEvent -> disconnectEvent.getLoginStatus() == DisconnectEvent.LoginStatus.CONFLICTING_LOGIN ? null : EventTask.async(() -> this.removePlayer(disconnectEvent.getPlayer()))));
    }

    public void injectPlayer(@NotNull Player player) {
        PlayerChannelHandler handler = new PlayerChannelHandler(this.plugin, player);
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        this.removePlayer(player);
        connectedPlayer.getConnection().getChannel().pipeline().addBefore("handler", KEY, (ChannelHandler)handler);
    }

    public void removePlayer(@NotNull Player player) {
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        Channel channel = connectedPlayer.getConnection().getChannel();
        if (channel.pipeline().get(KEY) != null) {
            channel.pipeline().remove(KEY);
        }
    }

    public Set<UUID> getHuskChatEntries() {
        return this.huskChatEntries;
    }

    public static class PlayerChannelHandler
    extends ChannelDuplexHandler
    implements VelocityChatListener {
        private static final String LEGACY_COMMAND_PREFIX = "/";
        private final VelocityHuskChat plugin;
        private final Player player;

        public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object packet) throws Exception {
            Optional<String> message = this.extractChatMessage(packet);
            if (message.isEmpty()) {
                super.channelRead(ctx, packet);
                return;
            }
            this.handleChat(message.get(), passthrough -> super.channelRead(ctx, packet));
        }

        @NotNull
        private Optional<String> extractChatMessage(Object msg) {
            if (msg instanceof SessionPlayerChatPacket) {
                SessionPlayerChatPacket session = (SessionPlayerChatPacket)msg;
                return Optional.of(session.getMessage());
            }
            if (msg instanceof KeyedPlayerChatPacket) {
                KeyedPlayerChatPacket keyed = (KeyedPlayerChatPacket)msg;
                return Optional.of(keyed.getMessage());
            }
            if (msg instanceof LegacyChatPacket) {
                LegacyChatPacket legacy = (LegacyChatPacket)msg;
                if (legacy.getMessage().startsWith(LEGACY_COMMAND_PREFIX)) {
                    return Optional.empty();
                }
                return Optional.of(legacy.getMessage());
            }
            return Optional.empty();
        }

        private void handleChat(@NotNull String message, @NotNull ThrowingConsumer<Void> ifAllowed) {
            ((CompletableFuture)this.dispatchEvent(message).thenApply(event -> event.getResult().isAllowed() && this.handlePlayerChat((PlayerChatEvent)event))).thenAccept(allowed -> {
                if (allowed.booleanValue()) {
                    ifAllowed.accept(null);
                }
            });
        }

        @NotNull
        private CompletableFuture<PlayerChatEvent> dispatchEvent(@NotNull String message) {
            return this.plugin.getServer().getEventManager().fire((Object)new PlayerChatEvent(this.player, message));
        }

        @Override
        @NotNull
        public HuskChat plugin() {
            return this.plugin;
        }

        public PlayerChannelHandler(VelocityHuskChat plugin, Player player) {
            this.plugin = plugin;
            this.player = player;
        }
    }
}

