/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.OnlineUser;

public class ShortcutCommand
extends CommandBase {
    private final String channelId;

    public ShortcutCommand(@NotNull String command, @NotNull String channelId, @NotNull HuskChat plugin) {
        super(List.of(command), "[message]", plugin);
        this.channelId = channelId;
    }

    @Override
    public void onExecute(@NotNull OnlineUser player, @NotNull String[] args) {
        if (args.length == 0) {
            if (player instanceof ConsoleUser) {
                this.plugin.getLocales().sendMessage(player, "error_console_switch_channels", new String[0]);
                return;
            }
            this.plugin.editUserCache(c -> c.switchPlayerChannel(player, this.channelId, this.plugin));
        } else {
            StringJoiner message = new StringJoiner(" ");
            for (String arg : args) {
                message.add(arg);
            }
            Optional<Channel> optionalChannel = this.plugin.getChannels().getChannel(this.channelId);
            if (optionalChannel.isEmpty()) {
                this.plugin.getLocales().sendMessage(player, "error_no_channel", new String[0]);
                return;
            }
            Channel channel = optionalChannel.get();
            if (channel.getBroadcastScope().isPassThrough()) {
                this.plugin.getLocales().sendMessage(player, "error_passthrough_shortcut_command", new String[0]);
                return;
            }
            new ChatMessage(channel, player, message.toString(), this.plugin).dispatch();
        }
    }

    @Override
    @Nullable
    public String getPermission(String ... args) {
        return this.plugin.getChannels().getChannel(this.channelId).map(Channel::getPermissions).flatMap(Channel.ChannelPermissions::getSend).orElse(null);
    }
}

