/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.config.Channels;
import net.william278.huskchat.config.Filters;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.NameFormatters;
import net.william278.huskchat.libraries.configlib.YamlConfigurationProperties;
import net.william278.huskchat.libraries.configlib.YamlConfigurationStore;
import net.william278.huskchat.libraries.configlib.YamlConfigurations;
import net.william278.huskchat.user.UserCache;

public interface ConfigProvider {
    @NotNull
    public static final YamlConfigurationProperties.Builder<?> YAML_CONFIGURATION_PROPERTIES = (YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).setNameFormatter(NameFormatters.LOWER_UNDERSCORE);

    default public void loadConfig() {
        this.loadSettings();
        this.loadChannels();
        this.loadFilterSettings();
        this.loadLocales();
        this.loadUserCache();
    }

    @NotNull
    public Settings getSettings();

    public void setSettings(@NotNull Settings var1);

    default public void loadSettings() {
        this.setSettings(YamlConfigurations.update(this.getConfigDirectory().resolve("config.yml"), Settings.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       HuskChat - Config      \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskchat/\n\u2523\u2578 Config Help: https://william278.net/docs/huskchat/config-files/\n\u2517\u2578 Documentation: https://william278.net/docs/huskchat/")).build()));
    }

    @NotNull
    public Channels getChannels();

    public void setChannels(@NotNull Channels var1);

    default public void loadChannels() {
        this.setChannels(YamlConfigurations.update(this.getConfigDirectory().resolve("channels.yml"), Channels.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskChat - Channels     \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskchat/\n\u2517\u2578 Channels Help: https://william278.net/docs/huskchat/channels/")).build()));
    }

    @NotNull
    public Filters getFilterSettings();

    public void setFilterSettings(@NotNull Filters var1);

    default public void loadFilterSettings() {
        this.setFilterSettings(YamlConfigurations.update(this.getConfigDirectory().resolve("filters.yml"), Filters.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskChat - Filters      \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskchat/\n\u2517\u2578 Channels Help: https://william278.net/docs/huskchat/filters-and-replacers/")).build()));
    }

    @NotNull
    public Locales getLocales();

    public void setLocales(@NotNull Locales var1);

    default public void loadLocales() {
        YamlConfigurationStore<Locales> store = new YamlConfigurationStore<Locales>(Locales.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskChat - Locales      \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 See plugin about menu for international locale credits\n\u2523\u2578 Formatted in MineDown: https://github.com/Phoenix616/MineDown\n\u2517\u2578 Translate HuskClaims: https://william278.net/docs/huskchat/translations")).build());
        Path path = this.getConfigDirectory().resolve(String.format("messages-%s.yml", this.getSettings().getLanguage()));
        if (Files.exists(path, new LinkOption[0])) {
            this.setLocales(store.load(path));
            return;
        }
        try (InputStream input = this.getResource(String.format("locales/%s.yml", this.getSettings().getLanguage()));){
            Locales locales = store.read(input);
            store.save(locales, path);
            this.setLocales(locales);
        }
        catch (Throwable e) {
            this.getPlugin().log(Level.SEVERE, "An error occurred loading the locales (invalid lang code?)", e);
        }
    }

    @NotNull
    public UserCache getUserCache();

    public void setUserCache(@NotNull UserCache.Editor var1);

    default public void loadUserCache() {
        Path cacheFile = this.getConfigDirectory().resolve("user_cache.yml");
        this.setUserCache(cacheFile.toFile().exists() ? YamlConfigurations.load(cacheFile, UserCache.Editor.class) : new UserCache.Editor());
    }

    default public void editUserCache(@NotNull Consumer<UserCache.Editor> userCache) {
        userCache.accept((UserCache.Editor)this.getUserCache());
        YamlConfigurations.save(this.getConfigDirectory().resolve("user_cache.yml"), UserCache.class, this.getUserCache());
    }

    public InputStream getResource(@NotNull String var1);

    @NotNull
    public Path getConfigDirectory();

    @NotNull
    public HuskChat getPlugin();
}

