/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.listener;

import java.util.Optional;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.listener.PlayerListener;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.user.BukkitUser;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class BukkitListener
extends PlayerListener
implements Listener {
    public BukkitListener(@NotNull HuskChat plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        BukkitUser player = BukkitUser.adapt(e.getPlayer(), this.plugin);
        Optional channel = this.plugin.getUserCache().getPlayerChannel(player.getUuid()).flatMap(channelId -> this.plugin.getChannels().getChannel((String)channelId));
        if (channel.isEmpty()) {
            this.plugin.getLocales().sendMessage(player, "error_no_channel", new String[0]);
            return;
        }
        if (new ChatMessage((Channel)channel.get(), player, e.getMessage(), this.plugin).dispatch()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        BukkitUser player = BukkitUser.adapt(e.getPlayer(), this.plugin);
        super.handlePlayerSwitchServer(player, player.getServerName());
        if (this.plugin.getSettings().getJoinAndQuitMessages().getJoin().isEnabled() || !this.plugin.getSettings().getJoinAndQuitMessages().getBroadcastScope().isPassThrough()) {
            e.setJoinMessage(null);
        }
        super.handlePlayerJoin(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        if (this.plugin.getSettings().getJoinAndQuitMessages().getQuit().isEnabled() || !this.plugin.getSettings().getJoinAndQuitMessages().getBroadcastScope().isPassThrough()) {
            e.setQuitMessage(null);
        }
        super.handlePlayerQuit(BukkitUser.adapt(e.getPlayer(), this.plugin));
    }
}

