/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.api.BungeeHuskChatAPI;
import net.william278.huskchat.command.BungeeCommand;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.config.Channels;
import net.william278.huskchat.config.Filters;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.event.BungeeEventProvider;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.getter.BungeePermsDataGetter;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.bstats.bungeecord.Metrics;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.listener.BungeeListener;
import net.william278.huskchat.placeholders.DefaultReplacer;
import net.william278.huskchat.placeholders.PAPIProxyBridgeReplacer;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.user.BungeeUser;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;

public final class BungeeHuskChat
extends Plugin
implements HuskChat,
BungeeEventProvider {
    private static final int METRICS_ID = 11882;
    private final List<ChatFilter> filtersAndReplacers = new ArrayList<ChatFilter>();
    private final List<PlaceholderReplacer> placeholderReplacers = new ArrayList<PlaceholderReplacer>();
    private BungeeAudiences audiences;
    private Settings settings;
    private Locales locales;
    private Channels channels;
    private Filters filterSettings;
    private UserCache.Editor userCache;
    private DiscordHook discordHook;
    private DataGetter dataGetter;

    public void onEnable() {
        this.audiences = BungeeAudiences.create(this);
        this.loadConfig();
        this.loadFilters();
        BungeeHuskChatAPI.register(this);
        this.dataGetter = this.isPluginPresent("LuckPerms") ? new LuckPermsDataGetter() : (this.isPluginPresent("BungeePerms") ? new BungeePermsDataGetter() : new DefaultDataGetter());
        this.placeholderReplacers.add(new DefaultReplacer(this));
        if (this.getSettings().getPlaceholder().isUsePapi() && this.isPluginPresent("PAPIProxyBridge")) {
            this.placeholderReplacers.add(new PAPIProxyBridgeReplacer(this));
        }
        this.loadDiscordHook();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeListener(this));
        BungeeCommand.Type.registerAll(this);
        this.getChannels().getChannels().forEach(channel -> channel.getShortcutCommands().forEach(command -> new BungeeCommand(new ShortcutCommand((String)command, channel.getId(), (HuskChat)this), this)));
        new Metrics(this, 11882);
        this.checkForUpdates();
        this.log(Level.INFO, "Enabled HuskChat version " + this.getVersion(), new Throwable[0]);
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    @Override
    @NotNull
    public String getPluginDescription() {
        return this.getDescription().getDescription();
    }

    @Override
    @NotNull
    public String getPlatform() {
        return ProxyServer.getInstance().getName();
    }

    @Override
    public Optional<DiscordHook> getDiscordHook() {
        return Optional.ofNullable(this.discordHook);
    }

    @Override
    public Optional<OnlineUser> getPlayer(@NotNull UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            return Optional.of(BungeeUser.adapt(player, this));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Collection<OnlineUser> getOnlinePlayers() {
        ArrayList<OnlineUser> crossPlatform = new ArrayList<OnlineUser>();
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            crossPlatform.add(BungeeUser.adapt(player, this));
        }
        return crossPlatform;
    }

    @Override
    @NotNull
    public Collection<OnlineUser> getOnlinePlayersOnServer(@NotNull OnlineUser user) {
        return ((BungeeUser)user).getPlayer().getServer().getInfo().getPlayers().stream().map(player -> BungeeUser.adapt(player, this)).toList();
    }

    @Override
    public InputStream getResource(@NotNull String path) {
        return this.getResourceAsStream(path);
    }

    @Override
    @NotNull
    public Path getConfigDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    public boolean isPluginPresent(@NotNull String dependency) {
        return ProxyServer.getInstance().getPluginManager().getPlugin(dependency) != null;
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    @Override
    public Optional<OnlineUser> findPlayer(@NotNull String username) {
        Optional<OnlineUser> optionalPlayer;
        if (username.isEmpty()) {
            return Optional.empty();
        }
        if (ProxyServer.getInstance().getPlayer(username) != null) {
            ProxiedPlayer player = ProxyServer.getInstance().getPlayer(username);
            optionalPlayer = Optional.of(BungeeUser.adapt(player, this));
        } else {
            List<ProxiedPlayer> matchedPlayers = ProxyServer.getInstance().matchPlayer(username).stream().filter(val -> val.getName().startsWith(username)).sorted().toList();
            optionalPlayer = !matchedPlayers.isEmpty() ? Optional.of(BungeeUser.adapt(matchedPlayers.get(0), this)) : Optional.empty();
        }
        return optionalPlayer;
    }

    @Override
    @NotNull
    public Audience getAudience(@NotNull UUID user) {
        return this.audiences.player(user);
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.audiences.console();
    }

    @Override
    @NotNull
    public HuskChat getPlugin() {
        return this;
    }

    @Override
    public List<ChatFilter> getFiltersAndReplacers() {
        return this.filtersAndReplacers;
    }

    @Override
    public List<PlaceholderReplacer> getPlaceholderReplacers() {
        return this.placeholderReplacers;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public Channels getChannels() {
        return this.channels;
    }

    @Override
    public Filters getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public UserCache.Editor getUserCache() {
        return this.userCache;
    }

    @Override
    public DataGetter getDataGetter() {
        return this.dataGetter;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Override
    public void setChannels(Channels channels) {
        this.channels = channels;
    }

    @Override
    public void setFilterSettings(Filters filterSettings) {
        this.filterSettings = filterSettings;
    }

    @Override
    public void setUserCache(UserCache.Editor userCache) {
        this.userCache = userCache;
    }

    @Override
    public void setDiscordHook(DiscordHook discordHook) {
        this.discordHook = discordHook;
    }
}

