/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Unmodifiable;
import net.william278.huskchat.libraries.configlib.Comment;
import net.william278.huskchat.libraries.configlib.Configuration;

@Configuration
public class Settings {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       HuskChat - Config      \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskchat/\n\u2523\u2578 Config Help: https://william278.net/docs/huskchat/config-files/\n\u2517\u2578 Documentation: https://william278.net/docs/huskchat/";
    @Comment(value={"Locale of the default language file to use. Docs: https://william278.net/docs/huskclaims/translations"})
    private String language = "en-gb";
    @Comment(value={"Whether to automatically check for plugin updates on startup"})
    private boolean checkForUpdates = true;
    @Comment(value={"Whether to handle chat packets directly for better 1.19+ support (may cause rare compatibility issues)"})
    private boolean usePacketListening = true;
    @Comment(value={"Placeholder settings"})
    private PlaceholderSettings placeholder = new PlaceholderSettings();
    @Comment(value={"Message comamnd settings"})
    private MessageSettings messageCommand = new MessageSettings();
    @Comment(value={"Social spy settings (see other users' private messages)"})
    private SocialSpySettings socialSpy = new SocialSpySettings();
    @Comment(value={"(Bungee/Velocity only) Local spy settings (see local messages on other servers)"})
    private LocalSpySettings localSpy = new LocalSpySettings();
    @Comment(value={"Broadcast command settings"})
    private BroadcastSettings broadcastCommand = new BroadcastSettings();
    @Comment(value={"Join and quit message settings"})
    private JoinQuitSettings joinAndQuitMessages = new JoinQuitSettings();
    @Comment(value={"Discord integration settings. Docs: https://william278.net/docs/huskchat/discord-hook"})
    private DiscordSettings discord = new DiscordSettings();
    @Comment(value={"Custom names to display wherever you use the \"%server%\" placeholder instead of their default name"})
    private Map<String, String> serverNameReplacement = new HashMap<String, String>(Map.of("very-long-server-name", "VLSN"));

    @NotNull
    public static List<String> formatCommands(@NotNull List<String> rawCommands) {
        return rawCommands.stream().map(c -> c.startsWith("/") ? c.substring(1) : c).toList();
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public boolean isUsePacketListening() {
        return this.usePacketListening;
    }

    public PlaceholderSettings getPlaceholder() {
        return this.placeholder;
    }

    public MessageSettings getMessageCommand() {
        return this.messageCommand;
    }

    public SocialSpySettings getSocialSpy() {
        return this.socialSpy;
    }

    public LocalSpySettings getLocalSpy() {
        return this.localSpy;
    }

    public BroadcastSettings getBroadcastCommand() {
        return this.broadcastCommand;
    }

    public JoinQuitSettings getJoinAndQuitMessages() {
        return this.joinAndQuitMessages;
    }

    public DiscordSettings getDiscord() {
        return this.discord;
    }

    public Map<String, String> getServerNameReplacement() {
        return this.serverNameReplacement;
    }

    private Settings() {
    }

    @Configuration
    public static class PlaceholderSettings {
        @Comment(value={"Use PlaceholderAPI. If you're on Bungee/Velocity, this requires PAPIProxyBridge installed"})
        private boolean usePapi = true;
        @Comment(value={"If using PAPIProxyBridge, how long to cache placeholders for (in milliseconds)"})
        private long cacheTime = 3000L;

        public boolean isUsePapi() {
            return this.usePapi;
        }

        public long getCacheTime() {
            return this.cacheTime;
        }

        private PlaceholderSettings() {
        }
    }

    @Configuration
    public static class MessageSettings {
        @Comment(value={"Whether to enable the /msg command"})
        private boolean enabled = true;
        @Comment(value={"List of command aliases for /msg"})
        private List<String> msgAliases = List.of("/msg", "/m", "/tell", "/whisper", "/w", "/pm");
        @Comment(value={"List of command aliases for /reply"})
        private List<String> replyAliases = List.of("/reply", "/r");
        @Comment(value={"Whether to apply censorship filters on private messages"})
        private boolean censor = false;
        @Comment(value={"Whether to log private messages to the console"})
        private boolean logToConsole = true;
        @Comment(value={"Logging format for private messages"})
        private String logFormat = "[MSG] [%sender% -> %receiver%]: ";
        @Comment(value={"Group private message settings"})
        private GroupSettings groupMessages = new GroupSettings();
        @Comment(value={"Formats for private messages (uses MineDown)"})
        private MessageFormat format = new MessageFormat();
        @Comment(value={"(Bungee/Velocity only) List of servers where private messages cannot be sent"})
        private List<String> restrictedServers = List.of();

        @NotNull
        public List<String> getMsgAliases() {
            return Settings.formatCommands(this.msgAliases);
        }

        @NotNull
        public List<String> getReplyAliases() {
            return Settings.formatCommands(this.replyAliases);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isCensor() {
            return this.censor;
        }

        public boolean isLogToConsole() {
            return this.logToConsole;
        }

        public String getLogFormat() {
            return this.logFormat;
        }

        public GroupSettings getGroupMessages() {
            return this.groupMessages;
        }

        public MessageFormat getFormat() {
            return this.format;
        }

        public List<String> getRestrictedServers() {
            return this.restrictedServers;
        }

        private MessageSettings() {
        }

        @Configuration
        public static class GroupSettings {
            @Comment(value={"Whether to enable group private messages (/msg Player1,Player2,...)"})
            private boolean enabled = true;
            @Comment(value={"Maximum amount of players in a group message"})
            private int maxSize = 10;

            public boolean isEnabled() {
                return this.enabled;
            }

            public int getMaxSize() {
                return this.maxSize;
            }

            private GroupSettings() {
            }
        }

        @Configuration
        public static class MessageFormat {
            private String inbound = "&e&l%name% &8\u2192 &e&lYou&8: &f";
            private String outbound = "&e&lYou &8\u2192 &e&l%name%&8: &f";
            private String groupInbound = "&e&l%name% &8\u2192 &e&lYou[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%)&8: &f";
            private String groupOutbound = "&e&lYou &8\u2192 &e&l%name%[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%)&8: &f";

            public String getInbound() {
                return this.inbound;
            }

            public String getOutbound() {
                return this.outbound;
            }

            public String getGroupInbound() {
                return this.groupInbound;
            }

            public String getGroupOutbound() {
                return this.groupOutbound;
            }

            private MessageFormat() {
            }
        }
    }

    @Configuration
    public static class SocialSpySettings {
        private boolean enabled = true;
        private String format = "&e[Spy] &7%name% &8\u2192 &7%receiver_name%:%spy_color% ";
        private String groupFormat = "&e[Spy] &7%name% &8\u2192 &7%receiver_name% [\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members% suggest_command=/msg %group_members_comma_separated% ):%spy_color% ";
        private List<String> socialspyAliases = List.of("/socialspy", "/ss");

        @NotNull
        public List<String> getSocialspyAliases() {
            return Settings.formatCommands(this.socialspyAliases);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getFormat() {
            return this.format;
        }

        public String getGroupFormat() {
            return this.groupFormat;
        }

        private SocialSpySettings() {
        }

        private SocialSpySettings(boolean enabled, String format, String groupFormat, List<String> socialspyAliases) {
            this.enabled = enabled;
            this.format = format;
            this.groupFormat = groupFormat;
            this.socialspyAliases = socialspyAliases;
        }
    }

    @Configuration
    public static class LocalSpySettings {
        private boolean enabled = true;
        private String format = "&e[Spy] &7%name% &8\u2192 &7%receiver_name%:%spy_color% ";
        private List<String> localspyAliases = List.of("/socialspy", "/ss");
        @Comment(value={"List of channels to exclude from local spy"})
        private List<String> excludedLocalChannels = List.of();

        @NotNull
        public List<String> getLocalspyAliases() {
            return Settings.formatCommands(this.localspyAliases);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getFormat() {
            return this.format;
        }

        public List<String> getExcludedLocalChannels() {
            return this.excludedLocalChannels;
        }

        private LocalSpySettings() {
        }

        private LocalSpySettings(boolean enabled, String format, List<String> localspyAliases, List<String> excludedLocalChannels) {
            this.enabled = enabled;
            this.format = format;
            this.localspyAliases = localspyAliases;
            this.excludedLocalChannels = excludedLocalChannels;
        }
    }

    @Configuration
    public static class BroadcastSettings {
        private boolean enabled = true;
        private List<String> broadcastAliases = List.of("/broadcast", "/alert");
        private String format = "&6[Broadcast]&e ";
        private boolean logToConsole = true;
        private String logFormat = "[BROADCAST]: ";

        @NotNull
        public List<String> getBroadcastAliases() {
            return Settings.formatCommands(this.broadcastAliases);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isLogToConsole() {
            return this.logToConsole;
        }

        public String getLogFormat() {
            return this.logFormat;
        }

        private BroadcastSettings() {
        }
    }

    @Configuration
    public static class JoinQuitSettings {
        @Comment(value={"Use the \"huskchat.join_message.[text]\" permission to override this.", "Use the \"huskchat.silent_join\" permission to silence for a user."})
        private ConnectionMessage join = new ConnectionMessage(true, "&e%name% joined the network");
        @Comment(value={"Use the \"huskchat.quit_message.[text]\" permission to override this.", "Use the \"huskchat.silent_quit\" permission to silence for a user."})
        private ConnectionMessage quit = new ConnectionMessage(true, "&e%name% left the network");
        @Comment(value={"Note that on Velocity/Bungee, PASSTHROUGH modes won't cancel local join/quit messages"})
        private Channel.BroadcastScope broadcastScope = Channel.BroadcastScope.GLOBAL;

        public ConnectionMessage getJoin() {
            return this.join;
        }

        public ConnectionMessage getQuit() {
            return this.quit;
        }

        public Channel.BroadcastScope getBroadcastScope() {
            return this.broadcastScope;
        }

        private JoinQuitSettings() {
        }

        @Configuration
        public static class ConnectionMessage {
            private boolean enabled;
            private String format;

            public boolean isEnabled() {
                return this.enabled;
            }

            public String getFormat() {
                return this.format;
            }

            private ConnectionMessage() {
            }

            private ConnectionMessage(boolean enabled, String format) {
                this.enabled = enabled;
                this.format = format;
            }
        }
    }

    @Configuration
    public static class DiscordSettings {
        @Comment(value={"Enable hooking into Discord via Webhooks and/or Spicord"})
        private boolean enabled = false;
        @Comment(value={"Discord message format style (INLINE or EMBEDDED)"})
        private DiscordHook.Format formatStyle = DiscordHook.Format.INLINE;
        @Comment(value={"Send messages in channels to a webhook by mapped URL"})
        private Map<String, String> channelWebhooks = new HashMap<String, String>();
        @Comment(value={"Whether to hook into Spicord for two-way chat"})
        private SpicordSettings spicord = new SpicordSettings();

        @NotNull
        public @Unmodifiable Map<String, URL> getChannelWebhooks() throws IllegalStateException {
            HashMap<String, URL> webhookMap = new HashMap<String, URL>();
            for (String channel : this.channelWebhooks.keySet()) {
                try {
                    webhookMap.put(channel, new URI(this.channelWebhooks.get(channel)).toURL());
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Invalid URL for Discord webhook: " + this.channelWebhooks.get(channel));
                }
            }
            return webhookMap;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public DiscordHook.Format getFormatStyle() {
            return this.formatStyle;
        }

        public SpicordSettings getSpicord() {
            return this.spicord;
        }

        private DiscordSettings() {
        }

        @Configuration
        public static class SpicordSettings {
            @Comment(value={"Requires Spicord installed and \"huskchat\" added to the \"addons\" in config.toml"})
            private boolean enabled = true;
            @Comment(value={"Format of Discord users in-game. Note this doesn't support other placeholders"})
            private String usernameFormat = "@%discord_handle%";
            @Comment(value={"Send in-game messages on these channels to a specified Discord channel (by numeric ID)"})
            private Map<String, String> receiveChannelMap = new HashMap<String, String>(Map.of("global", "123456789012345678"));
            @Comment(value={"Send Discord messages on these channels (by numeric ID) to a specified in-game channel"})
            private Map<String, String> sendChannelMap = new HashMap<String, String>(Map.of("123456789012345678", "global"));

            public boolean isEnabled() {
                return this.enabled;
            }

            public String getUsernameFormat() {
                return this.usernameFormat;
            }

            public Map<String, String> getReceiveChannelMap() {
                return this.receiveChannelMap;
            }

            public Map<String, String> getSendChannelMap() {
                return this.sendChannelMap;
            }

            private SpicordSettings() {
            }
        }
    }
}

