/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.william278.huskchat.BukkitHuskChat;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.MessageCommand;
import net.william278.huskchat.command.OptOutMessageCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.BukkitUser;
import net.william278.huskchat.user.ConsoleUser;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitCommand
extends Command {
    private final BukkitHuskChat plugin;
    private final CommandBase command;

    public BukkitCommand(@NotNull CommandBase command, @NotNull BukkitHuskChat plugin) {
        super(command.getName(), command.getUsage(), command.getUsage(), command.getAliases());
        this.setPermission(command.getPermission(new String[0]));
        this.command = command;
        this.plugin = plugin;
        plugin.getCommandMap().register("huskchat", (Command)this);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.command.onExecute(BukkitUser.adapt(player, this.plugin), args);
        } else {
            this.command.onExecute(ConsoleUser.wrap(this.plugin), args);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        if (!(sender instanceof Player)) {
            return this.command.onTabComplete(this.plugin.getConsoleUser(), args);
        }
        Player player = (Player)sender;
        BukkitUser user = BukkitUser.adapt(player, this.plugin);
        if (!user.hasPermission(this.command.getPermission(new String[0]), !this.command.isOperatorOnly())) {
            return List.of();
        }
        return this.command.onTabComplete(user, args);
    }

    public boolean testPermissionSilent(@NotNull CommandSender target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            return BukkitUser.adapt(player, this.plugin).hasPermission(this.command.getPermission(new String[0]), !this.command.isOperatorOnly());
        }
        return true;
    }

    public static enum Type {
        HUSKCHAT(plugin -> Optional.of(new BukkitCommand(new HuskChatCommand((HuskChat)plugin), (BukkitHuskChat)plugin))),
        CHANNEL(plugin -> Optional.of(new BukkitCommand(new ChannelCommand((HuskChat)plugin), (BukkitHuskChat)plugin))),
        MESSAGE(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new BukkitCommand(new MessageCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        REPLY(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new BukkitCommand(new ReplyCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        OPT_OUT_MESSAGE(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new BukkitCommand(new OptOutMessageCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        BROADCAST(plugin -> plugin.getSettings().getBroadcastCommand().isEnabled() ? Optional.of(new BukkitCommand(new BroadcastCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        SOCIAL_SPY(plugin -> plugin.getSettings().getSocialSpy().isEnabled() ? Optional.of(new BukkitCommand(new SocialSpyCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty());

        private final Function<BukkitHuskChat, Optional<BukkitCommand>> commandSupplier;

        private Type(Function<BukkitHuskChat, Optional<BukkitCommand>> commandSupplier) {
            this.commandSupplier = commandSupplier;
        }

        private void register(@NotNull BukkitHuskChat plugin) {
            this.commandSupplier.apply(plugin);
        }

        public static void registerAll(@NotNull BukkitHuskChat plugin) {
            Arrays.stream(Type.values()).forEach(type -> type.register(plugin));
        }
    }
}

