/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.List;
import java.util.Locale;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.user.OnlineUser;

public abstract class CommandBase {
    protected final HuskChat plugin;
    protected final List<String> aliases;
    protected final String usage;
    protected boolean operatorOnly = false;

    public CommandBase(@NotNull List<String> aliases, @NotNull String usage, @NotNull HuskChat plugin) {
        if (aliases.isEmpty()) {
            throw new IllegalArgumentException("Command must have at least one alias");
        }
        this.aliases = aliases.stream().map(s -> s.toLowerCase(Locale.ENGLISH)).toList();
        this.usage = usage;
        this.plugin = plugin;
    }

    public abstract void onExecute(@NotNull OnlineUser var1, @NotNull String[] var2);

    @NotNull
    public List<String> onTabComplete(@NotNull OnlineUser player, @NotNull String[] args) {
        return List.of();
    }

    @NotNull
    public String getName() {
        return this.aliases.get(0);
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases.subList(1, this.aliases.size());
    }

    @NotNull
    public String getUsage() {
        return "/" + this.getName() + " " + this.usage;
    }

    @Nullable
    public String getPermission(String ... children) {
        return String.join((CharSequence)".", "huskchat", "command", this.getName(), String.join((CharSequence)".", children));
    }

    public boolean isOperatorOnly() {
        return this.operatorOnly;
    }
}

