/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.PrivateMessage;
import net.william278.huskchat.user.OnlineUser;

public class MessageCommand
extends CommandBase {
    public MessageCommand(@NotNull HuskChat plugin) {
        super(plugin.getSettings().getMessageCommand().getMsgAliases(), plugin.getSettings().getMessageCommand().getGroupMessages().isEnabled() ? "<player(s)> <message>" : "<player> <message>", plugin);
    }

    @Override
    public void onExecute(@NotNull OnlineUser player, @NotNull String[] args) {
        if (args.length >= 2) {
            StringJoiner message = new StringJoiner(" ");
            int messageWordCount = 0;
            for (String arg : args) {
                if (messageWordCount >= 1) {
                    message.add(arg);
                }
                ++messageWordCount;
            }
            List<String> targetPlayers = this.getTargetPlayers(args[0]);
            String messageToSend = message.toString();
            new PrivateMessage(player, targetPlayers, messageToSend, this.plugin).dispatch();
        } else {
            this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
        }
    }

    private List<String> getTargetPlayers(String playerList) {
        if (!playerList.contains(",")) {
            return Collections.singletonList(playerList);
        }
        return List.of(playerList.split(","));
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull OnlineUser player, @NotNull String[] args) {
        if (args.length <= 1) {
            ArrayList<String> userNames = new ArrayList<String>();
            for (OnlineUser connectedPlayer : this.plugin.getOnlinePlayers()) {
                if (player.getUuid().equals(connectedPlayer.getUuid())) continue;
                userNames.add(connectedPlayer.getName());
            }
            String currentText = args.length == 1 ? args[0] : "";
            Object precursoryText = "";
            String[] names = new String[]{};
            if (currentText.contains(",")) {
                names = currentText.split(",");
                currentText = names[names.length - 1];
                CharSequence[] previousNames = Arrays.copyOf(names, names.length - 1);
                precursoryText = String.join((CharSequence)",", previousNames) + (previousNames.length != 0 ? "," : "");
            }
            String completionFilter = currentText;
            ArrayList<String> prependedUsernames = new ArrayList<String>();
            for (String username : userNames.stream().filter(val -> val.toLowerCase().startsWith(completionFilter.toLowerCase())).sorted().toList()) {
                if (names.length != 0 && Arrays.stream(names).anyMatch(name -> name.equalsIgnoreCase(username))) continue;
                prependedUsernames.add((String)precursoryText + username);
            }
            return prependedUsernames;
        }
        return List.of();
    }
}

