/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;

public class CapsFilter
extends ChatFilter {
    public CapsFilter(ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new CapsFilterSettings();
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser player, @NotNull String message) {
        double messageLength = message.length();
        if (messageLength <= 5.0) {
            return true;
        }
        int capsLetters = 0;
        for (char messageChar : message.toCharArray()) {
            if (!Character.isUpperCase(messageChar)) continue;
            ++capsLetters;
        }
        double capsProportion = (double)capsLetters / messageLength;
        return !(capsProportion > ((CapsFilterSettings)this.settings).getMaxCapsPercentage());
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_caps";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.caps";
    }

    @Configuration
    public static class CapsFilterSettings
    extends ChatFilter.FilterSettings {
        public double maxCapsPercentage = 0.4;

        public double getMaxCapsPercentage() {
            return this.maxCapsPercentage;
        }

        private CapsFilterSettings() {
        }

        CapsFilterSettings(double maxCapsPercentage) {
            this.maxCapsPercentage = maxCapsPercentage;
        }
    }
}

