/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.ArrayList;
import java.util.List;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.configlib.Configuration;
import net.william278.huskchat.user.OnlineUser;

public class RegexFilter
extends ChatFilter {
    public RegexFilter(@NotNull ChatFilter.FilterSettings settings) {
        super(settings);
    }

    @Override
    public boolean isAllowed(@NotNull OnlineUser sender, @NotNull String message) {
        if (!this.settings.isEnabled()) {
            return true;
        }
        for (String pattern : ((RegexFilterSettings)this.settings).getPatterns()) {
            if (!message.matches(pattern)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getDisallowedLocale() {
        return "error_chat_filter_regex";
    }

    @Override
    @NotNull
    public String getIgnorePermission() {
        return "huskchat.ignore_filters.regex";
    }

    @NotNull
    public static ChatFilter.FilterSettings getDefaultSettings() {
        return new RegexFilterSettings();
    }

    @Configuration
    public static class RegexFilterSettings
    extends ChatFilter.FilterSettings {
        private List<String> patterns = new ArrayList<String>();

        private RegexFilterSettings() {
            this.enabled = false;
        }

        public List<String> getPatterns() {
            return this.patterns;
        }
    }
}

