/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.OnlineUser;
import net.william278.huskchat.user.UserCache;

public class ChatMessage {
    private final HuskChat plugin;
    private Channel channel;
    private OnlineUser sender;
    private String message;

    public ChatMessage(@NotNull Channel channel, @NotNull OnlineUser sender, @NotNull String message, @NotNull HuskChat plugin) {
        this.channel = channel;
        this.sender = sender;
        this.message = message;
        this.plugin = plugin;
    }

    public boolean dispatch() {
        AtomicReference<Channel> channel = new AtomicReference<Channel>(this.getChannel());
        if (!this.getChannel().canUserSend(this.getSender())) {
            this.getPlugin().getLocales().sendMessage(this.getSender(), "error_no_permission_send", channel.get().getId());
            return true;
        }
        for (String restrictedServer : channel.get().getRestrictedServers()) {
            if (!restrictedServer.equalsIgnoreCase(this.getSender().getServerName())) continue;
            this.getPlugin().getLocales().sendMessage(this.getSender(), "error_channel_restricted_server", channel.get().getId());
            return true;
        }
        Channel.BroadcastScope scope = channel.get().getBroadcastScope();
        if (this.getSender() instanceof ConsoleUser && (scope == Channel.BroadcastScope.LOCAL || scope == Channel.BroadcastScope.LOCAL_PASSTHROUGH)) {
            this.getPlugin().getLocales().sendMessage(this.getSender(), "error_console_local_scope", new String[0]);
            return true;
        }
        Optional<String> formatted = this.getPlugin().filter(this.getSender(), this.getMessage(), this.getPlugin().getChannelFilters(channel.get()));
        if (formatted.isEmpty()) {
            return true;
        }
        this.setMessage(formatted.get());
        HashSet<OnlineUser> messageRecipients = new HashSet<OnlineUser>();
        switch (scope) {
            case GLOBAL: 
            case GLOBAL_PASSTHROUGH: {
                messageRecipients.addAll(this.getPlugin().getOnlinePlayers());
                break;
            }
            case LOCAL: 
            case LOCAL_PASSTHROUGH: {
                messageRecipients.addAll(this.getPlugin().getOnlinePlayersOnServer(this.getSender()));
                break;
            }
        }
        this.getPlugin().fireChatMessageEvent(this.getSender(), this.getMessage(), channel.get().getId()).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.setSender(event.getSender());
            this.setMessage(event.getMessage());
            if (!event.getChannelId().equals(((Channel)channel.get()).getId())) {
                this.getPlugin().getChannels().getChannel(event.getChannelId()).ifPresent(channel::set);
            }
            messageRecipients.forEach(recipient -> {
                boolean isSender = recipient.getUuid().equals(this.getSender().getUuid());
                if (!isSender && !this.getChannel().canUserReceive((OnlineUser)recipient)) {
                    return;
                }
                if (((Channel)channel.get()).isServerRestricted(recipient.getServerName())) {
                    return;
                }
                this.getPlugin().getLocales().sendChannelMessage((OnlineUser)recipient, this.getSender(), (Channel)channel.get(), this.getMessage(), this.getPlugin());
                if (this.getPlugin().getSettings().getLocalSpy().isEnabled() && !this.getPlugin().getSettings().getLocalSpy().getExcludedLocalChannels().contains(((Channel)channel.get()).getId()) && scope.isOneOf(Channel.BroadcastScope.LOCAL, Channel.BroadcastScope.LOCAL_PASSTHROUGH)) {
                    Map<OnlineUser, UserCache.SpyColor> spies = this.getPlugin().getUserCache().getLocalSpies(this.getSender().getServerName(), this.getPlugin());
                    for (OnlineUser spy : spies.keySet()) {
                        if (spy.getUuid().equals(this.getSender().getUuid())) continue;
                        if (!spy.hasPermission("huskchat.command.localspy", false)) {
                            this.plugin.editUserCache(c -> c.removeLocalSpy(spy));
                            continue;
                        }
                        UserCache.SpyColor color = spies.get(spy);
                        this.getPlugin().getLocales().sendLocalSpy(spy, color, this.getSender(), (Channel)channel.get(), this.getMessage(), this.getPlugin());
                    }
                }
                if (((Channel)channel.get()).isLogToConsole()) {
                    String logFormat = this.getPlugin().getChannels().getChannelLogFormat().replaceAll("%channel%", ((Channel)channel.get()).getId().toUpperCase()).replaceAll("%sender%", this.getSender().getName());
                    this.getPlugin().log(Level.INFO, logFormat + this.getMessage(), new Throwable[0]);
                }
                if (this.getPlugin().getSettings().getDiscord().isEnabled()) {
                    this.getPlugin().getDiscordHook().ifPresent(hook -> hook.postMessage(this));
                }
            });
        });
        return !scope.isPassThrough();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public OnlineUser getSender() {
        return this.sender;
    }

    public String getMessage() {
        return this.message;
    }

    private HuskChat getPlugin() {
        return this.plugin;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setSender(OnlineUser sender) {
        this.sender = sender;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

