/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.annotations.TestOnly;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.user.User;

public abstract class OnlineUser
extends User {
    protected HuskChat plugin;

    protected OnlineUser(@NotNull String username, @NotNull UUID uuid, @NotNull HuskChat plugin) {
        super(username, uuid);
        this.plugin = plugin;
    }

    @TestOnly
    protected OnlineUser(@NotNull String username, @NotNull UUID uuid) {
        super(username, uuid);
    }

    public abstract int getPing();

    @NotNull
    public abstract String getServerName();

    public abstract int getPlayersOnServer();

    public abstract boolean hasPermission(@Nullable String var1, boolean var2);

    @NotNull
    public Audience getAudience() {
        return this.plugin.getAudience(this.getUuid());
    }

    public void sendMessage(@NotNull Component message) {
        this.getAudience().sendMessage(message);
    }

    public void sendMessage(@NotNull MineDown mineDown) {
        this.sendMessage(mineDown.toComponent());
    }
}

