/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import java.util.UUID;
import net.william278.huskchat.libraries.annotations.NotNull;

public class User
implements Comparable<User> {
    @NotNull
    private String name;
    @NotNull
    private UUID uuid;

    @NotNull
    public static User of(@NotNull UUID uuid, @NotNull String name) {
        return new User(name, uuid);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User user = (User)obj;
        return user.getUuid().equals(this.uuid);
    }

    @Override
    public int compareTo(@NotNull User o) {
        return this.name.compareTo(o.getName());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    private User() {
    }

    protected User(@NotNull String name, @NotNull UUID uuid) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.name = name;
        this.uuid = uuid;
    }
}

