/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class BackCommand
extends InGameCommand {
    protected BackCommand(@NotNull HuskHomes plugin) {
        super(List.of("back"), "", plugin);
        this.addAdditionalPermissions(Map.of("death", false, "previous", false));
    }

    @Override
    public void execute(@NotNull OnlineUser executor, @NotNull String[] args) {
        Optional<Position> lastPosition = this.plugin.getDatabase().getLastPosition(executor);
        if (lastPosition.isEmpty()) {
            this.plugin.getLocales().getLocale("error_no_last_position").ifPresent(executor::sendMessage);
            return;
        }
        Teleport.builder(this.plugin).teleporter(executor).target(lastPosition.get()).actions(TransactionResolver.Action.BACK_COMMAND).type(Teleport.Type.BACK).buildAndComplete(true, new String[0]);
    }
}

