/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.config.Server;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.config.Spawn;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.configlib.NameFormatters;
import net.william278.huskhomes.libraries.configlib.YamlConfigurationProperties;
import net.william278.huskhomes.libraries.configlib.YamlConfigurationStore;
import net.william278.huskhomes.libraries.configlib.YamlConfigurations;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.util.UnsafeBlocks;

public interface ConfigProvider {
    @NotNull
    public static final YamlConfigurationProperties.Builder<?> YAML_CONFIGURATION_PROPERTIES = (YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).setNameFormatter(NameFormatters.LOWER_UNDERSCORE);

    default public void loadConfigs() throws IllegalStateException {
        this.loadSettings();
        this.loadLocales();
        this.loadServer();
        this.loadServerSpawn();
        this.loadUnsafeBlocks();
    }

    @NotNull
    public Settings getSettings();

    public void setSettings(@NotNull Settings var1);

    default public void loadSettings() {
        this.setSettings(YamlConfigurations.update(this.getConfigDirectory().resolve("config.yml"), Settings.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       HuskHomes Config       \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskhomes/\n\u2523\u2578 Config Help: https://william278.net/docs/huskhomes/config-files/\n\u2517\u2578 Documentation: https://william278.net/docs/huskhomes/")).build()));
        Home.setDelimiter(this.getSettings().getGeneral().getHomeDelimiter());
    }

    @NotNull
    public Locales getLocales();

    public void setLocales(@NotNull Locales var1);

    default public void loadLocales() {
        YamlConfigurationStore<Locales> store = new YamlConfigurationStore<Locales>(Locales.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      HuskHomes Locales       \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 See plugin about menu for international locale credits\n\u2523\u2578 Formatted in MineDown: https://github.com/WiIIiam278/MineDown\n\u2517\u2578 Translate HuskHomes: https://william278.net/docs/huskhomes/translations")).build());
        Path path = this.getConfigDirectory().resolve(String.format("messages-%s.yml", this.getSettings().getLanguage()));
        if (Files.exists(path, new LinkOption[0])) {
            this.setLocales(store.load(path));
            return;
        }
        try (InputStream input = this.getResource(String.format("locales/%s.yml", this.getSettings().getLanguage()));){
            Locales locales = store.read(input);
            store.save(locales, path);
            this.setLocales(locales);
        }
        catch (Throwable e) {
            throw new IllegalStateException("An error occurred loading the locales (invalid lang code?)", e);
        }
    }

    @NotNull
    public String getServerName();

    public void setServerName(@NotNull Server var1);

    default public void loadServer() {
        if (this.getSettings().getCrossServer().isEnabled()) {
            this.setServerName(YamlConfigurations.update(this.getConfigDirectory().resolve("server.yml"), Server.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    HuskHomes - Server ID    \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 This file should contain the ID of this server as defined in your proxy config.\n\u2523\u2578 If you join it using /server alpha, then set it to 'alpha' (case-sensitive)\n\u2517\u2578 You only need to touch this if you're using cross-server mode.")).build()));
        }
    }

    public Optional<Spawn> getServerSpawn();

    public void setServerSpawn(@NotNull Spawn var1);

    default public void setServerSpawn(@NotNull Location location) {
        Spawn spawn = new Spawn(location);
        this.setServerSpawn(spawn);
        this.saveServerSpawn(spawn);
    }

    default public void saveServerSpawn(@NotNull Spawn spawn) {
        YamlConfigurations.save(this.getConfigDirectory().resolve("spawn.yml"), Spawn.class, spawn, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    Server /spawn location    \u2503\n\u2503 Edit in-game using /setspawn \u2503\n\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b")).build());
    }

    default public void loadServerSpawn() {
        Path spawn = this.getConfigDirectory().resolve("spawn.yml");
        if (Files.exists(spawn, new LinkOption[0])) {
            this.setServerSpawn(YamlConfigurations.update(this.getConfigDirectory().resolve("spawn.yml"), Spawn.class, ((YamlConfigurationProperties.Builder)YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    Server /spawn location    \u2503\n\u2503 Edit in-game using /setspawn \u2503\n\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b")).build()));
        }
    }

    @NotNull
    public UnsafeBlocks getUnsafeBlocks();

    public void setUnsafeBlocks(@NotNull UnsafeBlocks var1);

    default public void loadUnsafeBlocks() {
        Path path = this.getConfigDirectory().resolve("safety/unsafe_blocks.yml");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                this.setUnsafeBlocks(YamlConfigurations.load(path, UnsafeBlocks.class, YAML_CONFIGURATION_PROPERTIES.build()));
                this.getPlugin().log(Level.INFO, "Loaded custom unsafe blocks", new Throwable[0]);
                return;
            }
            catch (Exception e) {
                this.getPlugin().log(Level.WARNING, "An error occurred loading custom unsafe blocks. Will load built-in file instead.", e);
            }
        }
        try (InputStream input = this.getResource("safety/unsafe_blocks.yml");){
            this.setUnsafeBlocks(YamlConfigurations.read(input, UnsafeBlocks.class, YAML_CONFIGURATION_PROPERTIES.build()));
        }
        catch (Throwable e) {
            throw new IllegalStateException("An error occurred loading the unsafe blocks", e);
        }
    }

    public InputStream getResource(@NotNull String var1);

    @NotNull
    public Path getConfigDirectory();

    @NotNull
    public HuskHomes getPlugin();
}

