/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapDisabledEvent;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.event.world.WorldUnloadedEvent;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Icon;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Popup;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.world.World;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.hook.MapHook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.User;

@PluginHook(name="Pl3xMap", register=PluginHook.Register.ON_ENABLE)
public class Pl3xMapHook
extends MapHook
implements EventListener {
    private static final String ICON_PATH = "/images/icon/registered/";
    private static final String WARPS_LAYER = "warp_markers";
    private static final String PUBLIC_HOMES_LAYER = "public_home_markers";
    private final ConcurrentLinkedQueue<Home> publicHomes = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Warp> warps = new ConcurrentLinkedQueue();

    public Pl3xMapHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        Pl3xMap.api().getEventRegistry().register((EventListener)this);
        if (Pl3xMap.api().isEnabled()) {
            this.onPl3xMapEnabled(new Pl3xMapEnabledEvent());
        }
    }

    @Override
    public void addHome(@NotNull Home home) {
        this.publicHomes.remove(home);
        if (this.isValidPosition(home)) {
            this.publicHomes.add(home);
        }
    }

    @Override
    public void removeHome(@NotNull Home home) {
        this.publicHomes.remove(home);
    }

    @Override
    public void clearHomes(@NotNull User user) {
        this.publicHomes.removeIf(home -> home.getOwner().equals(user));
    }

    @Override
    public void clearHomes(@NotNull String worldName) {
        this.publicHomes.removeIf(home -> home.getWorld().getName().equals(worldName));
    }

    @Override
    public void addWarp(@NotNull Warp warp) {
        this.warps.remove(warp);
        if (this.isValidPosition(warp)) {
            this.warps.add(warp);
        }
    }

    @Override
    public void removeWarp(@NotNull Warp warp) {
        this.warps.remove(warp);
    }

    @Override
    public void clearWarps() {
        this.warps.clear();
    }

    @Override
    public void clearWarps(@NotNull String worldName) {
        this.warps.removeIf(warp -> warp.getWorld().getName().equals(worldName));
    }

    private void registerIcon(@NotNull String key, @NotNull String iconFileName) {
        try (InputStream iconStream = this.plugin.getResource(iconFileName);){
            if (iconStream == null) {
                this.plugin.log(Level.WARNING, "Failed to load Pl3xMap icon (" + key + "): icon file not found", new Throwable[0]);
                return;
            }
            Pl3xMap.api().getIconRegistry().register((Keyed)new IconImage(key, ImageIO.read(iconStream), "png"));
        }
        catch (IOException e) {
            this.plugin.log(Level.WARNING, "Failed to load Pl3xMap icon (" + key + "): " + e.getMessage(), e);
        }
    }

    private void registerLayers(@NotNull World world) {
        SimpleLayer layer;
        Settings.MapHookSettings settings = this.plugin.getSettings().getMapHook();
        if (settings.isShowWarps()) {
            layer = new WarpsLayer(this, world);
            world.getLayerRegistry().register((Keyed)layer);
        }
        if (settings.isShowPublicHomes()) {
            layer = new PublicHomesLayer(this, world);
            world.getLayerRegistry().register((Keyed)layer);
        }
    }

    @EventHandler
    public void onPl3xMapEnabled(@NotNull Pl3xMapEnabledEvent event) {
        Settings.MapHookSettings settings = this.plugin.getSettings().getMapHook();
        if (settings.isShowWarps()) {
            this.registerIcon(WARPS_LAYER, "markers/16x/warp.png");
        }
        if (settings.isShowPublicHomes()) {
            this.registerIcon(PUBLIC_HOMES_LAYER, "markers/16x/public-home.png");
        }
        Pl3xMap.api().getWorldRegistry().forEach(this::registerLayers);
        this.plugin.runAsync(() -> {
            this.plugin.getDatabase().getLocalPublicHomes(this.plugin).forEach(this::addHome);
            this.plugin.getDatabase().getLocalWarps(this.plugin).forEach(this::addWarp);
        });
    }

    @EventHandler
    public void onPl3xMapDisabled(@NotNull Pl3xMapDisabledEvent event) {
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            world.getLayerRegistry().unregister(WARPS_LAYER);
            world.getLayerRegistry().unregister(PUBLIC_HOMES_LAYER);
        });
    }

    @EventHandler
    public void onWorldLoaded(@NotNull WorldLoadedEvent event) {
        this.registerLayers(event.getWorld());
    }

    @EventHandler
    public void onWorldUnloaded(@NotNull WorldUnloadedEvent event) {
        event.getWorld().getLayerRegistry().unregister(WARPS_LAYER);
        event.getWorld().getLayerRegistry().unregister(PUBLIC_HOMES_LAYER);
    }

    @NotNull
    public Options getMarkerOptions(@NotNull SavedPosition position) {
        String string;
        Options.Builder builder = Options.builder().tooltip(new Tooltip(position.getIdentifier()));
        if (position instanceof Home) {
            Home home = (Home)position;
            string = MapHook.MarkerInformationPopup.publicHome(home, "/images/icon/registered/warp_markers").toHtml();
        } else if (position instanceof Warp) {
            Warp warp = (Warp)position;
            string = MapHook.MarkerInformationPopup.warp(warp, "/images/icon/registered/public_home_markers").toHtml();
        } else {
            string = "";
        }
        return builder.popup(new Popup(string)).build();
    }

    public static class WarpsLayer
    extends SimpleLayer {
        private final Pl3xMapHook hook;
        private final World mapWorld;

        public WarpsLayer(@NotNull Pl3xMapHook hook, @NotNull World mapWorld) {
            super(Pl3xMapHook.WARPS_LAYER, hook::getWarpsMarkerSetName);
            this.hook = hook;
            this.mapWorld = mapWorld;
        }

        @NotNull
        public Collection<Marker<?>> getMarkers() {
            return this.hook.warps.stream().filter(warp -> warp.getWorld().getName().equals(this.mapWorld.getName())).map(warp -> (Icon)Icon.of((String)this.hook.plugin.getKey("warp_" + String.valueOf(warp.getUuid())).asString(), (Point)Point.of((double)warp.getX(), (double)warp.getZ()), (String)Pl3xMapHook.WARPS_LAYER).setOptions(this.hook.getMarkerOptions((SavedPosition)warp))).collect(Collectors.toCollection(LinkedList::new));
        }
    }

    public static class PublicHomesLayer
    extends SimpleLayer {
        private final Pl3xMapHook hook;
        private final World mapWorld;

        public PublicHomesLayer(@NotNull Pl3xMapHook hook, @NotNull World mapWorld) {
            super(Pl3xMapHook.PUBLIC_HOMES_LAYER, hook::getPublicHomesMarkerSetName);
            this.hook = hook;
            this.mapWorld = mapWorld;
        }

        @NotNull
        public Collection<Marker<?>> getMarkers() {
            return this.hook.publicHomes.stream().filter(home -> home.getWorld().getName().equals(this.mapWorld.getName())).map(home -> (Icon)Marker.icon((String)this.hook.plugin.getKey("public_home_" + String.valueOf(home.getUuid())).asString(), (Point)Point.of((double)home.getX(), (double)home.getZ()), (String)Pl3xMapHook.PUBLIC_HOMES_LAYER).setOptions(this.hook.getMarkerOptions((SavedPosition)home))).collect(Collectors.toCollection(LinkedList::new));
        }
    }
}

