/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.gson.annotations.Expose;

public class World {
    @Expose
    private String name;
    @Expose
    private UUID uuid;
    @Expose
    @Nullable
    private Environment environment = null;

    @NotNull
    public static World from(@NotNull String name, @NotNull UUID uuid) {
        return new World(name, uuid, null);
    }

    @NotNull
    public static World from(@NotNull String name) {
        return World.from(name, UUID.randomUUID());
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment == null ? Environment.OVERWORLD : this.environment;
    }

    public boolean equals(@NotNull Object obj) {
        if (obj instanceof World) {
            World world = (World)obj;
            return this.uuid.equals(world.uuid);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    @Generated
    private World(String name, UUID uuid, @Nullable Environment environment) {
        this.name = name;
        this.uuid = uuid;
        this.environment = environment;
    }

    @Generated
    public static World from(String name, UUID uuid, @Nullable Environment environment) {
        return new World(name, uuid, environment);
    }

    @Generated
    public World() {
    }

    public static enum Environment {
        OVERWORLD,
        NETHER,
        THE_END,
        CUSTOM;


        @NotNull
        public static Environment match(@NotNull String name) {
            return switch (name.toLowerCase(Locale.ENGLISH)) {
                case "overworld" -> OVERWORLD;
                case "nether", "the_nether" -> NETHER;
                case "the_end" -> THE_END;
                default -> CUSTOM;
            };
        }
    }
}

